/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.UnsupportedTerminal;
import jline.console.ConsoleReader;
import jline.internal.Log;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ChatConverter;
import net.md_5.bungee.ConnectionThrottle;
import net.md_5.bungee.Metrics;
import net.md_5.bungee.NativeCipher;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.api.tab.CustomTabList;
import net.md_5.bungee.command.CommandAlert;
import net.md_5.bungee.command.CommandBungee;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandFind;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandList;
import net.md_5.bungee.command.CommandPerms;
import net.md_5.bungee.command.CommandReload;
import net.md_5.bungee.command.CommandSend;
import net.md_5.bungee.command.CommandServer;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.conf.Configuration;
import net.md_5.bungee.conf.YamlConfig;
import net.md_5.bungee.log.BungeeLogger;
import net.md_5.bungee.log.LoggingOutputStream;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.query.RemoteQuery;
import net.md_5.bungee.reconnect.YamlReconnectHandler;
import net.md_5.bungee.scheduler.BungeeScheduler;
import net.md_5.bungee.tab.Custom;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.fusesource.jansi.AnsiConsole;

public class BungeeCord
extends ProxyServer {
    public volatile boolean isRunning;
    public final Configuration config = new Configuration();
    public final ResourceBundle bundle = ResourceBundle.getBundle("messages");
    public final MultithreadEventLoopGroup eventLoops = new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty IO Thread #%1$d").build());
    private final Timer saveThread = new Timer("Reconnect Saver");
    private final Timer metricsThread = new Timer("Metrics Thread");
    private Collection<Channel> listeners = new HashSet<Channel>();
    private final Map<String, UserConnection> connections = new CaseInsensitiveMap<UserConnection>();
    private final ReadWriteLock connectionLock = new ReentrantReadWriteLock();
    public final PluginManager pluginManager = new PluginManager(this);
    private ReconnectHandler reconnectHandler;
    private ConfigurationAdapter configurationAdapter = new YamlConfig();
    private final Collection<String> pluginChannels = new HashSet<String>();
    private final File pluginsFolder = new File("plugins");
    private final BungeeScheduler scheduler = new BungeeScheduler();
    private ConsoleReader consoleReader;
    private final Logger logger;
    public final Gson gson = new Gson();
    private ConnectionThrottle connectionThrottle;

    public static BungeeCord getInstance() {
        return (BungeeCord)ProxyServer.getInstance();
    }

    public BungeeCord() throws IOException {
        this.getPluginManager().registerCommand(null, new CommandReload());
        this.getPluginManager().registerCommand(null, new CommandEnd());
        this.getPluginManager().registerCommand(null, new CommandList());
        this.getPluginManager().registerCommand(null, new CommandServer());
        this.getPluginManager().registerCommand(null, new CommandIP());
        this.getPluginManager().registerCommand(null, new CommandAlert());
        this.getPluginManager().registerCommand(null, new CommandBungee());
        this.getPluginManager().registerCommand(null, new CommandPerms());
        this.getPluginManager().registerCommand(null, new CommandSend());
        this.getPluginManager().registerCommand(null, new CommandFind());
        this.registerChannel("BungeeCord");
        Log.setOutput(new PrintStream(ByteStreams.nullOutputStream()));
        AnsiConsole.systemInstall();
        this.consoleReader = new ConsoleReader();
        this.consoleReader.setExpandEvents(false);
        this.logger = new BungeeLogger(this);
        System.setErr(new PrintStream(new LoggingOutputStream(this.logger, Level.SEVERE), true));
        System.setOut(new PrintStream(new LoggingOutputStream(this.logger, Level.INFO), true));
        if (this.consoleReader.getTerminal() instanceof UnsupportedTerminal) {
            this.logger.info("Unable to initialize fancy terminal. To fix this on Windows, install the correct Microsoft Visual C++ 2008 Runtime");
            this.logger.info("NOTE: This error is non crucial, and BungeeCord will still function correctly! Do not bug the author about it unless you are still unable to get it working");
        }
        if (!NativeCipher.load()) {
            this.logger.warning("NOTE: Failed to load native code. Falling back to Java cipher.");
        } else {
            this.logger.info("Native code loaded.");
        }
    }

    @Override
    public void start() throws Exception {
        ResourceLeakDetector.setEnabled(false);
        this.pluginsFolder.mkdir();
        this.pluginManager.detectPlugins(this.pluginsFolder);
        this.config.load();
        for (ListenerInfo info : this.config.getListeners()) {
            if (info.isForceDefault() || this.reconnectHandler != null) continue;
            this.reconnectHandler = new YamlReconnectHandler();
            break;
        }
        this.isRunning = true;
        this.pluginManager.loadAndEnablePlugins();
        this.connectionThrottle = new ConnectionThrottle(this.config.getThrottle());
        this.startListeners();
        this.saveThread.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (BungeeCord.this.getReconnectHandler() != null) {
                    BungeeCord.this.getReconnectHandler().save();
                }
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
        this.metricsThread.scheduleAtFixedRate((TimerTask)new Metrics(), 0L, TimeUnit.MINUTES.toMillis(10L));
    }

    public void startListeners() {
        for (final ListenerInfo info : this.config.getListeners()) {
            ChannelFutureListener listener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().info("Listening on " + info.getHost());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getHost(), future.cause());
                    }
                }
            };
            ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).childAttr(PipelineUtils.LISTENER, info).childHandler(PipelineUtils.SERVER_CHILD).group(this.eventLoops).localAddress(info.getHost())).bind().addListener(listener);
            if (!info.isQueryEnabled()) continue;
            ChannelFutureListener bindListener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().info("Started query on " + future.channel().localAddress());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + future.channel().remoteAddress(), future.cause());
                    }
                }
            };
            new RemoteQuery(this, info).start(new InetSocketAddress(info.getHost().getAddress(), info.getQueryPort()), this.eventLoops, bindListener);
        }
    }

    public void stopListeners() {
        for (Channel listener : this.listeners) {
            this.getLogger().log(Level.INFO, "Closing listener {0}", listener);
            try {
                listener.close().syncUninterruptibly();
            }
            catch (ChannelException ex) {
                this.getLogger().severe("Could not close listen thread");
            }
        }
        this.listeners.clear();
    }

    @Override
    public void stop() {
        new Thread("Shutdown Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BungeeCord.this.isRunning = false;
                BungeeCord.this.stopListeners();
                BungeeCord.this.getLogger().info("Closing pending connections");
                BungeeCord.this.connectionLock.readLock().lock();
                try {
                    BungeeCord.this.getLogger().info("Disconnecting " + BungeeCord.this.connections.size() + " connections");
                    for (UserConnection user : BungeeCord.this.connections.values()) {
                        user.disconnect(BungeeCord.this.getTranslation("restart", new Object[0]));
                    }
                }
                finally {
                    BungeeCord.this.connectionLock.readLock().unlock();
                }
                BungeeCord.this.getLogger().info("Closing IO threads");
                BungeeCord.this.eventLoops.shutdownGracefully();
                try {
                    BungeeCord.this.eventLoops.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (BungeeCord.this.reconnectHandler != null) {
                    BungeeCord.this.getLogger().info("Saving reconnect locations");
                    BungeeCord.this.reconnectHandler.save();
                    BungeeCord.this.reconnectHandler.close();
                }
                BungeeCord.this.saveThread.cancel();
                BungeeCord.this.metricsThread.cancel();
                BungeeCord.this.getLogger().info("Disabling plugins");
                for (Plugin plugin : BungeeCord.this.pluginManager.getPlugins()) {
                    try {
                        plugin.onDisable();
                    }
                    catch (Throwable t) {
                        BungeeCord.this.getLogger().severe("Exception disabling plugin " + plugin.getDescription().getName());
                        t.printStackTrace();
                    }
                    BungeeCord.this.getScheduler().cancel(plugin);
                }
                BungeeCord.this.scheduler.shutdown();
                BungeeCord.this.getLogger().info("Thankyou and goodbye");
                System.exit(0);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(DefinedPacket packet) {
        this.connectionLock.readLock().lock();
        try {
            for (UserConnection con : this.connections.values()) {
                con.unsafe().sendPacket(packet);
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public String getName() {
        return "BungeeCord";
    }

    @Override
    public String getVersion() {
        return BungeeCord.class.getPackage().getImplementationVersion() == null ? "unknown" : BungeeCord.class.getPackage().getImplementationVersion();
    }

    @Override
    public String getTranslation(String name, Object ... args) {
        String translation = "<translation '" + name + "' missing>";
        try {
            translation = MessageFormat.format(this.bundle.getString(name), args);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return translation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        this.connectionLock.readLock().lock();
        try {
            HashSet<ProxiedPlayer> hashSet = new HashSet<ProxiedPlayer>(this.connections.values());
            return hashSet;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public int getOnlineCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxiedPlayer getPlayer(String name) {
        this.connectionLock.readLock().lock();
        try {
            ProxiedPlayer proxiedPlayer = this.connections.get(name);
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        return this.config.getServers();
    }

    @Override
    public ServerInfo getServerInfo(String name) {
        return this.getServers().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getChannels() {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.pluginChannels);
        }
    }

    public PluginMessage registerChannels() {
        return new PluginMessage("REGISTER", Util.format(this.pluginChannels, "\u0000").getBytes());
    }

    @Override
    public int getProtocolVersion() {
        return 4;
    }

    @Override
    public String getGameVersion() {
        return "1.7.2";
    }

    @Override
    public ServerInfo constructServerInfo(String name, InetSocketAddress address, String motd, boolean restricted) {
        return new BungeeServerInfo(name, address, motd, restricted);
    }

    @Override
    public CommandSender getConsole() {
        return ConsoleCommandSender.getInstance();
    }

    @Override
    public void broadcast(String message) {
        this.getConsole().sendMessage(message);
        for (String msg : ChatConverter.toJSONChat(message)) {
            this.broadcast(new Chat(msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            this.connections.put(con.getName(), con);
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            this.connections.remove(con.getName());
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    @Override
    public CustomTabList customTabList(ProxiedPlayer player) {
        return new Custom(player);
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.config.getDisabledCommands();
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public ReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public void setReconnectHandler(ReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
    }

    @Override
    public ConfigurationAdapter getConfigurationAdapter() {
        return this.configurationAdapter;
    }

    @Override
    public void setConfigurationAdapter(ConfigurationAdapter configurationAdapter) {
        this.configurationAdapter = configurationAdapter;
    }

    @Override
    public File getPluginsFolder() {
        return this.pluginsFolder;
    }

    @Override
    public BungeeScheduler getScheduler() {
        return this.scheduler;
    }

    public ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public ConnectionThrottle getConnectionThrottle() {
        return this.connectionThrottle;
    }
}

