/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.util.Objects;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerDisconnectEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Position;
import net.md_5.bungee.api.score.Score;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.Team;

public class DownstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;
    private final ServerConnection server;

    @Override
    public void exception(Throwable t) throws Exception {
        ServerInfo def = this.bungee.getServerInfo(this.con.getPendingConnection().getListener().getFallbackServer());
        if (this.server.getInfo() != def) {
            this.server.setObsolete(true);
            this.con.connectNow(def);
            this.con.sendMessage(this.bungee.getTranslation("server_went_down", new Object[0]));
        } else {
            this.con.disconnect(Util.exception(t));
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.server.getInfo().removePlayer(this.con);
        if (this.bungee.getReconnectHandler() != null) {
            this.bungee.getReconnectHandler().setServer(this.con);
        }
        if (!this.server.isObsolete()) {
            this.con.disconnect(this.bungee.getTranslation("lost_connection", new Object[0]));
        }
        ServerDisconnectEvent serverDisconnectEvent = new ServerDisconnectEvent(this.con, this.server.getInfo());
        this.bungee.getPluginManager().callEvent(serverDisconnectEvent);
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        if (!this.server.isObsolete()) {
            EntityMap.rewrite(packet.buf, this.con.getServerEntityId(), this.con.getClientEntityId());
            this.con.sendPacket(packet);
        }
    }

    @Override
    public void handle(KeepAlive alive) throws Exception {
        this.con.setSentPingId(alive.getRandomId());
        this.con.setSentPingTime(System.currentTimeMillis());
    }

    @Override
    public void handle(PlayerListItem playerList) throws Exception {
        if (!this.con.getTabList().onListUpdate(playerList.getUsername(), playerList.isOnline(), playerList.getPing())) {
            throw new CancelSendSignal();
        }
    }

    @Override
    public void handle(ScoreboardObjective objective) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (objective.getAction()) {
            case 0: {
                serverScoreboard.addObjective(new Objective(objective.getName(), objective.getText()));
                break;
            }
            case 1: {
                serverScoreboard.removeObjective(objective.getName());
            }
        }
    }

    @Override
    public void handle(ScoreboardScore score) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (score.getAction()) {
            case 0: {
                Score s = new Score(score.getItemName(), score.getScoreName(), score.getValue());
                serverScoreboard.removeScore(score.getItemName());
                serverScoreboard.addScore(s);
                break;
            }
            case 1: {
                serverScoreboard.removeScore(score.getItemName());
            }
        }
    }

    @Override
    public void handle(ScoreboardDisplay displayScoreboard) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        serverScoreboard.setName(displayScoreboard.getName());
        serverScoreboard.setPosition(Position.values()[displayScoreboard.getPosition()]);
    }

    @Override
    public void handle(Team team) throws Exception {
        net.md_5.bungee.api.score.Team t;
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        if (team.getMode() == 1) {
            serverScoreboard.removeTeam(team.getName());
            return;
        }
        if (team.getMode() == 0) {
            t = new net.md_5.bungee.api.score.Team(team.getName());
            serverScoreboard.addTeam(t);
        } else {
            t = serverScoreboard.getTeam(team.getName());
        }
        if (t != null) {
            if (team.getMode() == 0 || team.getMode() == 2) {
                t.setDisplayName(team.getDisplayName());
                t.setPrefix(team.getPrefix());
                t.setSuffix(team.getSuffix());
                t.setFriendlyFire(team.isFriendlyFire());
            }
            if (team.getPlayers() != null) {
                for (String s : team.getPlayers()) {
                    if (team.getMode() == 0 || team.getMode() == 3) {
                        t.addPlayer(s);
                        continue;
                    }
                    t.removePlayer(s);
                }
            }
        }
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        DataInput in = pluginMessage.getStream();
        PluginMessageEvent event = new PluginMessageEvent(this.con.getServer(), this.con, pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw new CancelSendSignal();
        }
        if (pluginMessage.getTag().equals("BungeeCord")) {
            byte[] b;
            ServerInfo server;
            ProxiedPlayer player;
            ServerInfo server2;
            Object target;
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            String subChannel = in.readUTF();
            if (subChannel.equals("Forward")) {
                target = in.readUTF();
                String channel = in.readUTF();
                short len = in.readShort();
                byte[] data = new byte[len];
                in.readFully(data);
                out.writeUTF(channel);
                out.writeShort(data.length);
                out.write(data);
                byte[] payload = out.toByteArray();
                out = null;
                if (((String)target).equals("ALL")) {
                    for (ServerInfo server3 : this.bungee.getServers().values()) {
                        if (server3 == this.con.getServer().getInfo()) continue;
                        server3.sendData("BungeeCord", payload);
                    }
                } else {
                    ServerInfo server4 = this.bungee.getServerInfo((String)target);
                    if (server4 != null) {
                        server4.sendData("BungeeCord", payload);
                    }
                }
            }
            if (subChannel.equals("Connect") && (server2 = this.bungee.getServerInfo(in.readUTF())) != null) {
                this.con.connect(server2);
            }
            if (subChannel.equals("ConnectOther") && (player = this.bungee.getPlayer(in.readUTF())) != null && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                player.connect(server);
            }
            if (subChannel.equals("IP")) {
                out.writeUTF("IP");
                out.writeUTF(this.con.getAddress().getHostString());
                out.writeInt(this.con.getAddress().getPort());
            }
            if (subChannel.equals("PlayerCount")) {
                target = in.readUTF();
                out.writeUTF("PlayerCount");
                if (((String)target).equals("ALL")) {
                    out.writeUTF("ALL");
                    out.writeInt(this.bungee.getOnlineCount());
                } else {
                    server = this.bungee.getServerInfo((String)target);
                    if (server != null) {
                        out.writeUTF(server.getName());
                        out.writeInt(server.getPlayers().size());
                    }
                }
            }
            if (subChannel.equals("PlayerList")) {
                target = in.readUTF();
                out.writeUTF("PlayerList");
                if (((String)target).equals("ALL")) {
                    out.writeUTF("ALL");
                    out.writeUTF(Util.csv(this.bungee.getPlayers()));
                } else {
                    server = this.bungee.getServerInfo((String)target);
                    if (server != null) {
                        out.writeUTF(server.getName());
                        out.writeUTF(Util.csv(server.getPlayers()));
                    }
                }
            }
            if (subChannel.equals("GetServers")) {
                out.writeUTF("GetServers");
                out.writeUTF(Util.csv(this.bungee.getServers().keySet()));
            }
            if (subChannel.equals("Message") && (target = this.bungee.getPlayer(in.readUTF())) != null) {
                target.sendMessage(in.readUTF());
            }
            if (subChannel.equals("GetServer")) {
                out.writeUTF("GetServer");
                out.writeUTF(this.server.getInfo().getName());
            }
            if (subChannel.equals("UUID")) {
                out.writeUTF("UUID");
                out.writeUTF(this.con.getUUID());
            }
            if (subChannel.equals("UUIDOther") && (player = this.bungee.getPlayer(in.readUTF())) != null) {
                out.writeUTF("UUIDOther");
                out.writeUTF(player.getName());
                out.writeUTF(player.getUUID());
            }
            if (out != null && (b = out.toByteArray()).length != 0) {
                this.con.getServer().sendData("BungeeCord", b);
            }
        }
    }

    @Override
    public void handle(Kick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.bungee.getServerInfo(this.con.getPendingConnection().getListener().getFallbackServer());
        if (Objects.equals(this.server.getInfo(), def)) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.con, kick.getMessage(), def, ServerKickEvent.State.CONNECTED))).isCancelled() && event.getCancelServer() != null) {
            this.con.connectNow(event.getCancelServer());
        } else {
            this.con.disconnect0(event.getKickReason());
        }
        this.server.setObsolete(true);
        throw new CancelSendSignal();
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] <-> DownstreamBridge <-> [" + this.server.getInfo().getName() + "]";
    }

    @ConstructorProperties(value={"bungee", "con", "server"})
    public DownstreamBridge(ProxyServer bungee, UserConnection con, ServerConnection server) {
        this.bungee = bungee;
        this.con = con;
        this.server = server;
    }
}

