/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;

public class Util {
    private static final int DEFAULT_PORT = 25565;

    public static InetSocketAddress getAddr(String hostline) {
        String[] split = hostline.split(":");
        int port = 25565;
        if (split.length > 1) {
            port = Integer.parseInt(split[1]);
        }
        return new InetSocketAddress(split[0], port);
    }

    public static String hex(int i) {
        return String.format("0x%02X", i);
    }

    public static String exception(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        return t.getClass().getSimpleName() + " : " + t.getMessage() + (trace.length > 0 ? " @ " + t.getStackTrace()[0].getClassName() + ":" + t.getStackTrace()[0].getLineNumber() : "");
    }

    public static String csv(Iterable<?> objects) {
        return Util.format(objects, ", ");
    }

    public static String format(Iterable<?> objects, String separators) {
        return Joiner.on(separators).join(objects);
    }

    public static void main(String[] args) {
        System.out.println(Util.stupify("\u00a75H\u00a76E\u00a77L"));
    }

    public static String stupify(String text) {
        ArrayList<JsonObject> sections = new ArrayList<JsonObject>();
        char[] c = text.toCharArray();
        char currentChar = '\u0000';
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (c[i] == '\u00a7' && "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(c[i + 1]) != -1) {
                sections.add(Util.generateAndReset(currentChar, buffer));
                currentChar = Character.toLowerCase(c[++i]);
                continue;
            }
            buffer.append(c[i]);
        }
        sections.add(Util.generateAndReset(currentChar, buffer));
        return new Gson().toJson(sections);
    }

    private static JsonObject generateAndReset(char currentChar, StringBuilder buffer) {
        JsonObject entry = new JsonObject();
        ChatColor colour = ChatColor.getByChar(currentChar);
        if (colour != null) {
            entry.addProperty("color", colour.getName());
        }
        entry.addProperty("text", buffer.toString());
        buffer.setLength(0);
        return entry;
    }
}

