/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerHandshakeEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.http.HttpClient;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.CipherDecoder;
import net.md_5.bungee.netty.CipherEncoder;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.LegacyPing;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;

public class InitialHandler
extends PacketHandler
implements PendingConnection {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final ListenerInfo listener;
    private Login forgeLogin;
    private Handshake handshake;
    private LoginRequest loginRequest;
    private EncryptionRequest request;
    private List<PluginMessage> loginMessages = new ArrayList<PluginMessage>();
    private List<PluginMessage> registerMessages = new ArrayList<PluginMessage>();
    private State thisState = State.HANDSHAKE;
    private SecretKey sharedKey;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            InitialHandler.this.ch.write(packet);
        }
    };
    private boolean onlineMode;
    private InetSocketAddress vHost;
    private byte version;
    private String UUID;

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.disconnect((Object)((Object)ChatColor.RED) + Util.exception(t));
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("REGISTER")) {
            this.registerMessages.add(pluginMessage);
        } else {
            this.loginMessages.add(pluginMessage);
        }
    }

    @Override
    public void handle(LegacyPing ping) throws Exception {
        ServerPing legacy = new ServerPing(new ServerPing.Protocol(this.bungee.getGameVersion(), this.bungee.getProtocolVersion()), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.getOnlineCount()), null, this.listener.getMotd(), null);
        legacy = this.bungee.getPluginManager().callEvent(new ProxyPingEvent(this, legacy)).getResponse();
        String kickMessage = (Object)((Object)ChatColor.DARK_BLUE) + "\u0000" + legacy.getVersion().getProtocol() + "\u0000" + legacy.getVersion().getName() + "\u0000" + legacy.getDescription() + "\u0000" + legacy.getPlayers().getOnline() + "\u0000" + legacy.getPlayers().getMax();
        this.ch.getHandle().writeAndFlush(kickMessage);
        this.ch.close();
    }

    @Override
    public void handle(StatusRequest statusRequest) throws Exception {
        Preconditions.checkState(this.thisState == State.STATUS, "Not expecting STATUS");
        ServerInfo forced = AbstractReconnectHandler.getForcedHost(this);
        String motd = forced != null ? forced.getMotd() : this.listener.getMotd();
        Callback<ServerPing> pingBack = new Callback<ServerPing>(){

            @Override
            public void done(ServerPing result, Throwable error) {
                if (error != null) {
                    result = new ServerPing();
                    result.setDescription("Error pinging remote server: " + Util.exception(error));
                }
                result = InitialHandler.this.bungee.getPluginManager().callEvent(new ProxyPingEvent(InitialHandler.this, result)).getResponse();
                BungeeCord.getInstance().getConnectionThrottle().unthrottle(InitialHandler.this.getAddress().getAddress());
                InitialHandler.this.unsafe.sendPacket(new StatusResponse(BungeeCord.getInstance().gson.toJson(result)));
            }
        };
        if (forced != null && this.listener.isPingPassthrough()) {
            forced.ping(pingBack);
        } else {
            pingBack.done(new ServerPing(new ServerPing.Protocol(this.bungee.getGameVersion(), this.bungee.getProtocolVersion()), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.getOnlineCount()), null, motd, BungeeCord.getInstance().config.favicon), null);
        }
        this.thisState = State.PING;
    }

    @Override
    public void handle(PingPacket ping) throws Exception {
        Preconditions.checkState(this.thisState == State.PING, "Not expecting PING");
        this.unsafe.sendPacket(ping);
        this.disconnect("");
    }

    @Override
    public void handle(Handshake handshake) throws Exception {
        Preconditions.checkState(this.thisState == State.HANDSHAKE, "Not expecting HANDSHAKE");
        this.handshake = handshake;
        this.vHost = new InetSocketAddress(handshake.getHost(), handshake.getPort());
        this.bungee.getLogger().log(Level.INFO, "{0} has connected", this);
        if (BungeeCord.getInstance().config.isIpFoward()) {
            handshake.setHost(handshake.getHost() + "\u0000" + this.getAddress().getHostString());
        }
        this.bungee.getPluginManager().callEvent(new PlayerHandshakeEvent(this, handshake));
        switch (handshake.getRequestedProtocol()) {
            case 1: {
                this.thisState = State.STATUS;
                this.ch.setProtocol(Protocol.STATUS);
                break;
            }
            case 2: {
                this.thisState = State.USERNAME;
                this.ch.setProtocol(Protocol.LOGIN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot request protocol " + handshake.getRequestedProtocol());
            }
        }
    }

    @Override
    public void handle(LoginRequest loginRequest) throws Exception {
        Preconditions.checkState(this.thisState == State.USERNAME, "Not expecting USERNAME");
        this.loginRequest = loginRequest;
        if (this.handshake.getProtocolVersion() > this.bungee.getProtocolVersion()) {
            this.disconnect(this.bungee.getTranslation("outdated_server", new Object[0]));
            return;
        }
        if (this.handshake.getProtocolVersion() < this.bungee.getProtocolVersion()) {
            this.disconnect(this.bungee.getTranslation("outdated_client", new Object[0]));
            return;
        }
        if (this.getName().length() > 16) {
            this.disconnect("Cannot have username longer than 16 characters");
            return;
        }
        int limit = BungeeCord.getInstance().config.getPlayerLimit();
        if (limit > 0 && this.bungee.getOnlineCount() > limit) {
            this.disconnect(this.bungee.getTranslation("proxy_full", new Object[0]));
            return;
        }
        if (!this.isOnlineMode() && this.bungee.getPlayer(this.getName()) != null) {
            this.disconnect(this.bungee.getTranslation("already_connected", new Object[0]));
            return;
        }
        if (this.onlineMode) {
            this.request = EncryptionUtil.encryptRequest();
            this.unsafe().sendPacket(this.request);
        } else {
            this.finish();
        }
        this.thisState = State.ENCRYPT;
    }

    @Override
    public void handle(EncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT, "Not expecting ENCRYPT");
        this.sharedKey = EncryptionUtil.getSecret(encryptResponse, this.request);
        Cipher decrypt = EncryptionUtil.getCipher(2, this.sharedKey);
        this.ch.addBefore(PipelineUtils.FRAME_DECODER, PipelineUtils.DECRYPT_HANDLER, new CipherDecoder(decrypt));
        if (this.onlineMode) {
            String encName = URLEncoder.encode(this.getName(), "UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            for (byte[] bit : new byte[][]{this.request.getServerId().getBytes("ISO_8859_1"), this.sharedKey.getEncoded(), EncryptionUtil.keys.getPublic().getEncoded()}) {
                sha.update(bit);
            }
            String encodedHash = URLEncoder.encode(new BigInteger(sha.digest()).toString(16), "UTF-8");
            String authURL = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=" + encName + "&serverId=" + encodedHash;
            Callback<String> handler = new Callback<String>(){

                @Override
                public void done(String result, Throwable error) {
                    if (error == null) {
                        LoginResult obj = BungeeCord.getInstance().gson.fromJson(result, LoginResult.class);
                        if (obj != null) {
                            InitialHandler.this.UUID = obj.getId();
                            InitialHandler.this.finish();
                            return;
                        }
                        InitialHandler.this.disconnect("Not authenticated with Minecraft.net");
                    } else {
                        InitialHandler.this.disconnect(InitialHandler.this.bungee.getTranslation("mojang_fail", new Object[0]));
                        InitialHandler.this.bungee.getLogger().log(Level.SEVERE, "Error authenticating " + InitialHandler.this.getName() + " with minecraft.net", error);
                    }
                }
            };
            HttpClient.get(authURL, this.ch.getHandle().eventLoop(), handler);
        } else {
            this.finish();
        }
    }

    private void finish() {
        ProxiedPlayer old = this.bungee.getPlayer(this.getName());
        if (old != null) {
            old.disconnect(this.bungee.getTranslation("already_connected", new Object[0]));
        }
        Callback<LoginEvent> complete = new Callback<LoginEvent>(){

            @Override
            public void done(LoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    InitialHandler.this.disconnect(result.getCancelReason());
                }
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                InitialHandler.this.ch.getHandle().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (InitialHandler.this.ch.getHandle().isActive()) {
                            if (InitialHandler.this.onlineMode) {
                                try {
                                    Cipher encrypt = EncryptionUtil.getCipher(1, InitialHandler.this.sharedKey);
                                    InitialHandler.this.ch.addBefore(PipelineUtils.FRAME_PREPENDER, PipelineUtils.ENCRYPT_HANDLER, new CipherEncoder(encrypt));
                                }
                                catch (GeneralSecurityException ex) {
                                    InitialHandler.this.disconnect("Cipher error: " + Util.exception(ex));
                                }
                            }
                            if (InitialHandler.this.UUID == null) {
                                InitialHandler.this.UUID = java.util.UUID.randomUUID().toString();
                            }
                            InitialHandler.this.unsafe.sendPacket(new LoginSuccess(InitialHandler.this.UUID, InitialHandler.this.getName()));
                            InitialHandler.this.ch.setProtocol(Protocol.GAME);
                            UserConnection userCon = new UserConnection(InitialHandler.this.bungee, InitialHandler.this.ch, InitialHandler.this.getName(), InitialHandler.this);
                            userCon.init();
                            InitialHandler.this.bungee.getPluginManager().callEvent(new PostLoginEvent(userCon));
                            InitialHandler.this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new UpstreamBridge(InitialHandler.this.bungee, userCon));
                            ServerInfo server = InitialHandler.this.bungee.getReconnectHandler() != null ? InitialHandler.this.bungee.getReconnectHandler().getServer(userCon) : AbstractReconnectHandler.getForcedHost(InitialHandler.this);
                            userCon.connect(server, true);
                            InitialHandler.this.thisState = State.FINISHED;
                        }
                    }
                });
            }
        };
        this.bungee.getPluginManager().callEvent(new LoginEvent(this, complete));
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (!this.ch.isClosed()) {
            this.unsafe().sendPacket(new Kick(Util.stupify(reason)));
            this.ch.close();
        }
    }

    @Override
    public String getName() {
        return this.loginRequest == null ? null : this.loginRequest.getData();
    }

    @Override
    public int getVersion() {
        return this.handshake == null ? this.version : this.handshake.getProtocolVersion();
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return this.vHost;
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    public void setOnlineMode(boolean onlineMode) {
        Preconditions.checkState(this.thisState == State.HANDSHAKE, "Can only set online mode status whilst handshaking");
        this.onlineMode = onlineMode;
    }

    @Override
    public String toString() {
        return "[" + (this.getName() != null ? this.getName() : this.getAddress()) + "] <-> InitialHandler";
    }

    @ConstructorProperties(value={"bungee", "listener"})
    public InitialHandler(ProxyServer bungee, ListenerInfo listener) {
        this.onlineMode = BungeeCord.getInstance().config.isOnlineMode();
        this.version = (byte)-1;
        this.bungee = bungee;
        this.listener = listener;
    }

    @Override
    public ListenerInfo getListener() {
        return this.listener;
    }

    public Login getForgeLogin() {
        return this.forgeLogin;
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public LoginRequest getLoginRequest() {
        return this.loginRequest;
    }

    public List<PluginMessage> getLoginMessages() {
        return this.loginMessages;
    }

    public List<PluginMessage> getRegisterMessages() {
        return this.registerMessages;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public String getUUID() {
        return this.UUID;
    }

    private static enum State {
        HANDSHAKE,
        STATUS,
        PING,
        USERNAME,
        ENCRYPT,
        FINISHED;

    }
}

