/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.query;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class QueryHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private final ProxyServer bungee;
    private final ListenerInfo listener;
    private final Random random = new Random();
    private final Map<Integer, Long> sessions = new HashMap<Integer, Long>();

    private void writeShort(ByteBuf buf, int s) {
        buf.order(ByteOrder.LITTLE_ENDIAN).writeShort(s);
    }

    private void writeNumber(ByteBuf buf, int i) {
        this.writeString(buf, Integer.toString(i));
    }

    private void writeString(ByteBuf buf, String s) {
        for (char c : s.toCharArray()) {
            buf.writeChar(c);
        }
        buf.writeByte(0);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        int challengeToken;
        ByteBuf in = (ByteBuf)msg.content();
        if (in.readUnsignedByte() != 254 && in.readUnsignedByte() != 253) {
            throw new IllegalStateException("Incorrect magic!");
        }
        ByteBuf out = ctx.alloc().buffer();
        DatagramPacket response = new DatagramPacket(out, (InetSocketAddress)msg.sender());
        byte type = in.readByte();
        int sessionId = in.readInt();
        if (type == 9) {
            out.writeByte(9);
            out.writeInt(sessionId);
            challengeToken = this.random.nextInt();
            this.sessions.put(challengeToken, System.currentTimeMillis());
            this.writeNumber(out, challengeToken);
        }
        if (type == 0) {
            challengeToken = out.readInt();
            Long session = this.sessions.get(challengeToken);
            if (session == null || System.currentTimeMillis() - session > TimeUnit.SECONDS.toMillis(30L)) {
                throw new IllegalStateException("No session!");
            }
            out.writeByte(0);
            out.writeInt(sessionId);
            if (in.readableBytes() == 0) {
                this.writeString(out, this.listener.getMotd());
                this.writeString(out, "SMP");
                this.writeString(out, "BungeeCord_Proxy");
                this.writeNumber(out, this.bungee.getOnlineCount());
                this.writeNumber(out, this.listener.getMaxPlayers());
                this.writeShort(out, this.listener.getHost().getPort());
                this.writeString(out, this.listener.getHost().getHostString());
            } else if (in.readableBytes() == 8) {
                out.writeBytes(new byte[11]);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("hostname", this.listener.getMotd());
                data.put("gametype", "SMP");
                data.put("game_id", "MINECRAFT");
                data.put("version", this.bungee.getGameVersion());
                data.put("map", "BungeeCord_Proxy");
                data.put("numplayers", Integer.toString(this.bungee.getOnlineCount()));
                data.put("maxplayers", Integer.toString(this.listener.getMaxPlayers()));
                data.put("hostport", Integer.toString(this.listener.getHost().getPort()));
                data.put("hostip", this.listener.getHost().getHostString());
                for (Map.Entry entry : data.entrySet()) {
                    this.writeString(out, (String)entry.getKey());
                    this.writeString(out, (String)entry.getValue());
                }
                out.writeByte(0);
                out.writeBytes(new byte[10]);
                for (ProxiedPlayer p : this.bungee.getPlayers()) {
                    this.writeString(out, p.getName());
                }
                out.writeByte(0);
            } else {
                throw new IllegalStateException("Invalid data request packet");
            }
        }
        ctx.writeAndFlush(response);
    }

    @ConstructorProperties(value={"bungee", "listener"})
    public QueryHandler(ProxyServer bungee, ListenerInfo listener) {
        this.bungee = bungee;
        this.listener = listener;
    }
}

