/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class PacketFCEncryptionResponse
extends DefinedPacket {
    private byte[] sharedSecret;
    private byte[] verifyToken;

    private PacketFCEncryptionResponse() {
        super(252);
    }

    public PacketFCEncryptionResponse(byte[] sharedSecret, byte[] verifyToken) {
        this();
        this.sharedSecret = sharedSecret;
        this.verifyToken = verifyToken;
    }

    @Override
    public void read(ByteBuf buf) {
        this.sharedSecret = this.readArray(buf);
        this.verifyToken = this.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        this.writeArray(this.sharedSecret, buf);
        this.writeArray(this.verifyToken, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    @Override
    public String toString() {
        return "PacketFCEncryptionResponse(sharedSecret=" + Arrays.toString(this.getSharedSecret()) + ", verifyToken=" + Arrays.toString(this.getVerifyToken()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketFCEncryptionResponse)) {
            return false;
        }
        PacketFCEncryptionResponse other = (PacketFCEncryptionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getSharedSecret(), other.getSharedSecret())) {
            return false;
        }
        return Arrays.equals(this.getVerifyToken(), other.getVerifyToken());
    }

    public boolean canEqual(Object other) {
        return other instanceof PacketFCEncryptionResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + Arrays.hashCode(this.getSharedSecret());
        result = result * 31 + Arrays.hashCode(this.getVerifyToken());
        return result;
    }
}

