/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class Packet2Handshake
extends DefinedPacket {
    private byte procolVersion;
    private String username;
    private String host;
    private int port;

    private Packet2Handshake() {
        super(2);
    }

    @Override
    public void read(ByteBuf buf) {
        this.procolVersion = buf.readByte();
        this.username = this.readString(buf);
        this.host = this.readString(buf);
        this.port = buf.readInt();
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte(this.procolVersion);
        this.writeString(this.username, buf);
        this.writeString(this.host, buf);
        buf.writeInt(this.port);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public byte getProcolVersion() {
        return this.procolVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String toString() {
        return "Packet2Handshake(procolVersion=" + this.getProcolVersion() + ", username=" + this.getUsername() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Packet2Handshake)) {
            return false;
        }
        Packet2Handshake other = (Packet2Handshake)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcolVersion() != other.getProcolVersion()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    public boolean canEqual(Object other) {
        return other instanceof Packet2Handshake;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getProcolVersion();
        String $username = this.getUsername();
        result = result * 31 + ($username == null ? 0 : $username.hashCode());
        String $host = this.getHost();
        result = result * 31 + ($host == null ? 0 : $host.hashCode());
        result = result * 31 + this.getPort();
        return result;
    }
}

