/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.GenericConnection;
import net.md_5.bungee.KickException;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.command.CommandSender;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet0KeepAlive;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketC9PlayerListItem;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketInputStream;
import net.md_5.bungee.plugin.ServerConnectEvent;

public class UserConnection
extends GenericConnection
implements CommandSender {
    public final Packet2Handshake handshake;
    public Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();
    public List<byte[]> loginPackets = new ArrayList<byte[]>();
    private ServerConnection server;
    private UpstreamBridge upBridge;
    private DownstreamBridge downBridge;
    private int clientEntityId;
    private int serverEntityId;
    private volatile boolean reconnecting;
    private int trackingPingId;
    private long pingTime;
    private int ping;

    public UserConnection(Socket socket, PacketInputStream in, OutputStream out, Packet2Handshake handshake, List<byte[]> loginPackets) {
        super(socket, in, out);
        this.handshake = handshake;
        this.username = handshake.username;
        this.loginPackets = loginPackets;
        BungeeCord.instance.connections.put(this.username, this);
        BungeeCord.instance.tabListHandler.onJoin(this);
    }

    public void connect(String server) {
        ServerConnectEvent event = new ServerConnectEvent(this.server == null, this, server);
        event.setNewServer(server);
        BungeeCord.instance.pluginManager.onServerConnect(event);
        if (event.getMessage() != null) {
            this.sendMessage(event.getMessage());
        }
        if (event.getNewServer() == null) {
            if (event.isFirstTime()) {
                event.setNewServer(BungeeCord.instance.config.defaultServerName);
            } else {
                return;
            }
        }
        InetSocketAddress addr = BungeeCord.instance.config.getServer(event.getNewServer());
        this.connect(server, addr);
    }

    private void connect(String name, InetSocketAddress serverAddr) {
        BungeeCord.instance.tabListHandler.onServerChange(this);
        try {
            this.reconnecting = true;
            if (this.server != null) {
                this.out.write(new Packet9Respawn(1, 0, 0, 256, "DEFAULT").getPacket());
                this.out.write(new Packet9Respawn(-1, 0, 0, 256, "DEFAULT").getPacket());
            }
            ServerConnection newServer = ServerConnection.connect(this, name, serverAddr, this.handshake, this.server == null);
            if (this.server == null) {
                this.clientEntityId = newServer.loginPacket.entityId;
                this.serverEntityId = newServer.loginPacket.entityId;
                this.out.write(newServer.loginPacket.getPacket());
                this.upBridge = new UpstreamBridge();
                this.upBridge.start();
            } else {
                try {
                    this.downBridge.interrupt();
                    this.downBridge.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.server.disconnect("Quitting");
                Packet1Login login = newServer.loginPacket;
                this.serverEntityId = login.entityId;
                this.out.write(new Packet9Respawn(login.dimension, login.difficulty, login.gameMode, 256, login.levelType).getPacket());
            }
            this.reconnecting = false;
            this.downBridge = new DownstreamBridge();
            this.server = newServer;
            this.downBridge.start();
        }
        catch (KickException ex) {
            this.destroySelf(ex.getMessage());
        }
        catch (Exception ex) {
            this.destroySelf("Could not connect to server");
        }
    }

    public SocketAddress getAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public int getPing() {
        return this.ping;
    }

    private void setPing(int ping) {
        BungeeCord.instance.tabListHandler.onPingChange(this, ping);
        this.ping = ping;
    }

    private void destroySelf(String reason) {
        if (BungeeCord.instance.isRunning) {
            BungeeCord.instance.connections.remove(this.username);
        }
        this.disconnect(reason);
        if (this.server != null) {
            this.server.disconnect("Quitting");
            BungeeCord.instance.config.setServer(this, this.server.name);
        }
    }

    @Override
    public void disconnect(String reason) {
        BungeeCord.instance.tabListHandler.onDisconnect(this);
        super.disconnect(reason);
    }

    @Override
    public void sendMessage(String message) {
        this.packetQueue.add(new Packet3Chat(message));
    }

    @Override
    public String getName() {
        return this.username;
    }

    private class DownstreamBridge
    extends Thread {
        public DownstreamBridge() {
            super("Downstream Bridge - " + UserConnection.this.username);
        }

        @Override
        public void run() {
            try {
                while (!UserConnection.this.reconnecting) {
                    byte[] packet = ((UserConnection)UserConnection.this).server.in.readPacket();
                    int id = Util.getId(packet);
                    if (id == 250) {
                        PacketFAPluginMessage message = new PacketFAPluginMessage(packet);
                        if (message.tag.equals("RubberBand")) {
                            String server = new String(message.data);
                            UserConnection.this.connect(server);
                            break;
                        }
                    } else if (id == 0) {
                        UserConnection.this.trackingPingId = new Packet0KeepAlive((byte[])packet).id;
                        UserConnection.this.pingTime = System.currentTimeMillis();
                    } else if (id == 201 && !BungeeCord.instance.tabListHandler.onPacketC9(UserConnection.this, new PacketC9PlayerListItem(packet))) continue;
                    while (!UserConnection.this.packetQueue.isEmpty()) {
                        DefinedPacket p = UserConnection.this.packetQueue.poll();
                        if (p == null) continue;
                        UserConnection.this.out.write(p.getPacket());
                    }
                    EntityMap.rewrite(packet, UserConnection.this.serverEntityId, UserConnection.this.clientEntityId);
                    UserConnection.this.out.write(packet);
                }
            }
            catch (Exception ex) {
                UserConnection.this.destroySelf(Util.exception(ex));
            }
        }
    }

    private class UpstreamBridge
    extends Thread {
        public UpstreamBridge() {
            super("Upstream Bridge - " + UserConnection.this.username);
        }

        @Override
        public void run() {
            while (!UserConnection.this.socket.isClosed()) {
                try {
                    byte[] packet = UserConnection.this.in.readPacket();
                    boolean sendPacket = true;
                    int id = Util.getId(packet);
                    if (id == 3) {
                        Packet3Chat chat = new Packet3Chat(packet);
                        String message = chat.message;
                        if (message.startsWith("/")) {
                            sendPacket = !BungeeCord.instance.dispatchCommand(message.substring(1), UserConnection.this);
                        }
                    } else if (id == 0 && UserConnection.this.trackingPingId == new Packet0KeepAlive((byte[])packet).id) {
                        UserConnection.this.setPing((int)(System.currentTimeMillis() - UserConnection.this.pingTime));
                    }
                    EntityMap.rewrite(packet, UserConnection.this.clientEntityId, UserConnection.this.serverEntityId);
                    if (!sendPacket || ((UserConnection)UserConnection.this).server.socket.isClosed()) continue;
                    ((UserConnection)UserConnection.this).server.out.write(packet);
                }
                catch (IOException ex) {
                    UserConnection.this.destroySelf("Reached end of stream");
                }
                catch (Exception ex) {
                    UserConnection.this.destroySelf(Util.exception(ex));
                }
            }
        }
    }
}

