/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.AbstractNioChannel;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    protected AbstractNioMessageChannel(Channel parent, SelectableChannel ch, int readInterestOp) {
        super(parent, ch, readInterestOp);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioMessageUnsafe();
    }

    @Override
    protected int doWrite(Object[] msgs, int msgsLength, int startIndex) throws Exception {
        int writeSpinCount;
        for (int i = writeSpinCount = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
            int written = this.doWriteMessages(msgs, msgsLength, startIndex, i == 0);
            if (written <= 0) continue;
            return written;
        }
        return 0;
    }

    protected abstract int doReadMessages(List<Object> var1) throws Exception;

    protected abstract int doWriteMessages(Object[] var1, int var2, int var3, boolean var4) throws Exception;

    private final class NioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf = new ArrayList<Object>();

        private NioMessageUnsafe() {
        }

        @Override
        public void read() {
            int interestOps;
            assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
            SelectionKey key = AbstractNioMessageChannel.this.selectionKey();
            if (!AbstractNioMessageChannel.this.config().isAutoRead() && ((interestOps = key.interestOps()) & AbstractNioMessageChannel.this.readInterestOp) != 0) {
                key.interestOps(interestOps & ~AbstractNioMessageChannel.this.readInterestOp);
            }
            ChannelConfig config = AbstractNioMessageChannel.this.config();
            int maxMessagesPerRead = config.getMaxMessagesPerRead();
            boolean autoRead = config.isAutoRead();
            ChannelPipeline pipeline = AbstractNioMessageChannel.this.pipeline();
            boolean closed = false;
            Throwable exception = null;
            try {
                int localRead;
                while ((localRead = AbstractNioMessageChannel.this.doReadMessages(this.readBuf)) != 0) {
                    if (localRead < 0) {
                        closed = true;
                    } else if (!(this.readBuf.size() >= maxMessagesPerRead | !autoRead)) continue;
                    break;
                }
            }
            catch (Throwable t) {
                exception = t;
            }
            for (int i = 0; i < this.readBuf.size(); ++i) {
                pipeline.fireChannelRead(this.readBuf.get(i));
            }
            this.readBuf.clear();
            pipeline.fireChannelReadComplete();
            if (exception != null) {
                if (exception instanceof IOException) {
                    closed = !(AbstractNioMessageChannel.this instanceof ServerChannel);
                }
                pipeline.fireExceptionCaught(exception);
            }
            if (closed && AbstractNioMessageChannel.this.isOpen()) {
                this.close(this.voidPromise());
            }
        }
    }
}

