/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ChannelOutboundBuffer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final int MIN_INITIAL_CAPACITY = 8;
    MessageList currentMessages;
    int currentMessageIndex;
    private long currentMessageListSize;
    private MessageList[] messages;
    private long[] messageListSizes;
    private int head;
    private int tail;
    private boolean inFail;
    private final AbstractChannel channel;
    private long pendingOutboundBytes;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> WRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "writable");
    private volatile int writable = 1;

    ChannelOutboundBuffer(AbstractChannel channel) {
        this(channel, 16);
    }

    ChannelOutboundBuffer(AbstractChannel channel, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expected: >= 0)");
        }
        if (initialCapacity >= 8) {
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        } else {
            initialCapacity = 8;
        }
        this.messages = new MessageList[initialCapacity];
        this.messageListSizes = new long[initialCapacity];
        this.channel = channel;
    }

    void addMessage(Object msg, ChannelPromise promise) {
        int tail = this.tail;
        MessageList msgs = this.messages[tail];
        if (msgs == null) {
            this.messages[tail] = msgs = MessageList.newInstance();
        }
        msgs.add(msg, promise);
        int size = this.channel.calculateMessageSize(msg);
        int n = tail;
        this.messageListSizes[n] = this.messageListSizes[n] + (long)size;
        this.incrementPendingOutboundBytes(size);
    }

    void addFlush() {
        int tail = this.tail;
        if (this.messages[tail] == null) {
            return;
        }
        this.tail = tail + 1 & this.messages.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    private void incrementPendingOutboundBytes(int size) {
        if (size == 0) {
            return;
        }
        long newWriteBufferSize = this.pendingOutboundBytes += (long)size;
        int highWaterMark = this.channel.config().getWriteBufferHighWaterMark();
        if (newWriteBufferSize > (long)highWaterMark && WRITABLE_UPDATER.compareAndSet(this, 1, 0)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private void decrementPendingOutboundBytes(long size) {
        if (size == 0L) {
            return;
        }
        long newWriteBufferSize = this.pendingOutboundBytes -= size;
        int lowWaterMark = this.channel.config().getWriteBufferLowWaterMark();
        if ((newWriteBufferSize == 0L || newWriteBufferSize < (long)lowWaterMark) && WRITABLE_UPDATER.compareAndSet(this, 0, 1)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.messages.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        MessageList[] a1 = new MessageList[newCapacity];
        System.arraycopy(this.messages, p, a1, 0, r);
        System.arraycopy(this.messages, 0, a1, r, p);
        this.messages = a1;
        long[] a2 = new long[newCapacity];
        System.arraycopy(this.messageListSizes, p, a2, 0, r);
        System.arraycopy(this.messageListSizes, 0, a2, r, p);
        this.messageListSizes = a2;
        this.head = 0;
        this.tail = n;
    }

    boolean next() {
        this.decrementPendingOutboundBytes(this.currentMessageListSize);
        int h = this.head;
        MessageList e = this.messages[h];
        if (e == null) {
            this.currentMessageListSize = 0L;
            this.currentMessages = null;
            return false;
        }
        this.currentMessages = this.messages[h];
        this.currentMessageIndex = 0;
        this.currentMessageListSize = this.messageListSizes[h];
        this.messages[h] = null;
        this.messageListSizes[h] = 0L;
        this.head = h + 1 & this.messages.length - 1;
        return true;
    }

    boolean getWritable() {
        return WRITABLE_UPDATER.get(this) == 1;
    }

    int size() {
        return this.tail - this.head & this.messages.length - 1;
    }

    boolean isEmpty() {
        return this.head == this.tail;
    }

    void clear() {
        int head = this.head;
        int tail = this.tail;
        if (head != tail) {
            this.tail = 0;
            this.head = 0;
            int mask = this.messages.length - 1;
            int i = head;
            do {
                this.messages[i] = null;
                this.messageListSizes[i] = 0L;
            } while ((i = i + 1 & mask) != tail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(Throwable cause) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            if (this.currentMessages == null && !this.next()) {
                return;
            }
            do {
                if (this.currentMessages == null) continue;
                MessageList current = this.currentMessages;
                Object[] messages = this.currentMessages.messages();
                ChannelPromise[] promises = this.currentMessages.promises();
                int size = this.currentMessages.size();
                try {
                    for (int i = this.currentMessageIndex; i < size; ++i) {
                        ReferenceCountUtil.release(messages[i]);
                        ChannelPromise p = promises[i];
                        if (p instanceof VoidChannelPromise || p.tryFailure(cause)) continue;
                        logger.warn("Promise done already: {} - new exception is:", (Object)p, (Object)cause);
                    }
                }
                finally {
                    current.recycle();
                }
            } while (this.next());
        }
        finally {
            this.inFail = false;
        }
    }
}

