/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.MessageList;

public class ChannelWrapper {
    private final Channel ch;
    private volatile boolean closed;
    private final MessageList<Object> queue = MessageList.newInstance();
    private volatile boolean flushNow = true;

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
    }

    public synchronized void flushNow(boolean flush) {
        if (!this.flushNow && flush) {
            this.ch.write(this.queue.copy());
            this.queue.clear();
        }
        this.flushNow = flush;
    }

    public synchronized void write(Object packet) {
        if (!this.closed) {
            if (this.flushNow) {
                this.ch.write(packet);
            } else {
                this.queue.add(packet);
            }
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.ch.write(this.queue, this.ch.newPromise()).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    ChannelWrapper.this.ch.close();
                }
            });
        }
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState(this.ch.eventLoop().inEventLoop(), "cannot add handler outside of event loop");
        boolean oldFlush = this.flushNow;
        this.flushNow(true);
        this.ch.pipeline().addBefore(baseName, name, handler);
        this.flushNow(oldFlush);
    }

    public Channel getHandle() {
        return this.ch;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

