/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.md_5.bungee.api.CommandSender;

public abstract class Command {
    private final String name;
    private final String permission;
    private final String[] aliases;

    public Command(String name) {
        this(name, null, new String[0]);
    }

    public Command(String name, String permission, String ... aliases) {
        Preconditions.checkArgument(name != null, "name");
        this.name = name;
        this.permission = permission;
        this.aliases = aliases;
    }

    public abstract void execute(CommandSender var1, String[] var2);

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Command)) {
            return false;
        }
        Command other = (Command)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$permission = this.getPermission();
        String other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        return Arrays.deepEquals(this.getAliases(), other.getAliases());
    }

    public boolean canEqual(Object other) {
        return other instanceof Command;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        String $permission = this.getPermission();
        result = result * 31 + ($permission == null ? 0 : $permission.hashCode());
        result = result * 31 + Arrays.deepHashCode(this.getAliases());
        return result;
    }

    public String toString() {
        return "Command(name=" + this.getName() + ", permission=" + this.getPermission() + ", aliases=" + Arrays.deepToString(this.getAliases()) + ")";
    }
}

