/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import com.ning.http.multipart.MultipartEncodingUtil;
import com.ning.http.multipart.PartBase;
import java.io.IOException;
import java.io.OutputStream;

public class StringPart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_CHARSET = "US-ASCII";
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private byte[] content;
    private final String value;

    public StringPart(String name, String value, String charset, String contentId) {
        super(name, DEFAULT_CONTENT_TYPE, charset == null ? DEFAULT_CHARSET : charset, DEFAULT_TRANSFER_ENCODING, contentId);
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.value = value;
    }

    public StringPart(String name, String value, String charset) {
        this(name, value, charset, null);
    }

    public StringPart(String name, String value) {
        this(name, value, null);
    }

    private byte[] getContent() {
        if (this.content == null) {
            this.content = MultipartEncodingUtil.getBytes(this.value, this.getCharSet());
        }
        return this.content;
    }

    protected void sendData(OutputStream out) throws IOException {
        out.write(this.getContent());
    }

    protected long lengthOfData() throws IOException {
        return this.getContent().length;
    }

    public void setCharSet(String charSet) {
        super.setCharSet(charSet);
        this.content = null;
    }
}

