/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.string;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToByteEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, ByteBuf out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        ByteBuf encoded = Unpooled.copiedBuffer(msg, this.charset);
        out.writeBytes(encoded);
    }
}

