/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.util.Signal;

public interface ByteBufProcessor {
    public static final Signal ABORT = new Signal(ByteBufProcessor.class.getName() + ".ABORT");
    public static final ByteBufProcessor FIND_NUL = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value == 0) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_NON_NUL = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value != 0) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_CR = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value == 13) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_NON_CR = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value != 13) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_LF = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value == 10) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_NON_LF = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value != 10) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_CRLF = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value == 13 || value == 10) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_NON_CRLF = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value != 13 && value != 10) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_LINEAR_WHITESPACE = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value == 32 || value == 9) {
                throw ABORT;
            }
            return 1;
        }
    };
    public static final ByteBufProcessor FIND_NON_LINEAR_WHITESPACE = new ByteBufProcessor(){

        @Override
        public int process(byte value) throws Exception {
            if (value != 32 && value != 9) {
                throw ABORT;
            }
            return 1;
        }
    };

    public int process(byte var1) throws Exception;
}

