/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.PacketWrapper;

public class HandlerBoss
extends ChannelInboundMessageHandlerAdapter<Object> {
    private ChannelWrapper channel;
    private PacketHandler handler;

    public void setHandler(PacketHandler handler) {
        Preconditions.checkArgument(handler != null, "handler");
        this.handler = handler;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.channel = new ChannelWrapper(ctx);
            this.handler.connected(this.channel);
            if (!(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has connected", this.handler);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.handler.disconnected(this.channel);
            if (!(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has disconnected", this.handler);
            }
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.handler != null && ctx.channel().isActive()) {
            if (msg instanceof PacketWrapper) {
                boolean sendPacket = true;
                try {
                    ((PacketWrapper)msg).packet.handle(this.handler);
                }
                catch (CancelSendSignal ex) {
                    sendPacket = false;
                }
                if (sendPacket) {
                    this.handler.handle(((PacketWrapper)msg).buf);
                }
            } else {
                this.handler.handle((byte[])msg);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            if (cause instanceof ReadTimeoutException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, this.handler + " - read timed out");
            } else if (cause instanceof IOException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, this.handler + " - IOException: " + cause.getMessage());
            } else {
                ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - encountered exception", cause);
            }
            if (this.handler != null) {
                try {
                    this.handler.exception(cause);
                }
                catch (Exception ex) {
                    ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - exception processing exception", ex);
                }
            }
            ctx.close();
        }
    }
}

