/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.util.DateUtil;
import java.util.ArrayList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnectionsPool
implements ConnectionsPool<String, Channel> {
    private static final Logger log = LoggerFactory.getLogger(NettyConnectionsPool.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<IdleChannel>> connectionsPool = new ConcurrentHashMap();
    private final ConcurrentHashMap<Channel, IdleChannel> channel2IdleChannel = new ConcurrentHashMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Timer idleConnectionDetector = new Timer(true);
    private final boolean sslConnectionPoolEnabled;
    private final int maxTotalConnections;
    private final int maxConnectionPerHost;
    private final long maxIdleTime;

    public NettyConnectionsPool(NettyAsyncHttpProvider provider) {
        this(provider.getConfig().getMaxTotalConnections(), provider.getConfig().getMaxConnectionPerHost(), provider.getConfig().getIdleConnectionInPoolTimeoutInMs(), provider.getConfig().isSslConnectionPoolEnabled());
    }

    public NettyConnectionsPool(int maxTotalConnections, int maxConnectionPerHost, long maxIdleTime, boolean sslConnectionPoolEnabled) {
        this.maxTotalConnections = maxTotalConnections;
        this.maxConnectionPerHost = maxConnectionPerHost;
        this.sslConnectionPoolEnabled = sslConnectionPoolEnabled;
        this.maxIdleTime = maxIdleTime;
        this.idleConnectionDetector.schedule((TimerTask)new IdleChannelDetector(), maxIdleTime, maxIdleTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(String uri, Channel channel) {
        boolean added;
        ConcurrentLinkedQueue newPool;
        if (this.isClosed.get()) {
            return false;
        }
        if (!this.sslConnectionPoolEnabled && uri.startsWith("https")) {
            return false;
        }
        log.debug("Adding uri: {} for channel {}", (Object)uri, (Object)channel);
        channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(new NettyAsyncHttpProvider.DiscardEvent());
        ConcurrentLinkedQueue<IdleChannel> idleConnectionForHost = this.connectionsPool.get(uri);
        if (idleConnectionForHost == null && (idleConnectionForHost = this.connectionsPool.putIfAbsent(uri, newPool = new ConcurrentLinkedQueue())) == null) {
            idleConnectionForHost = newPool;
        }
        int size = idleConnectionForHost.size();
        if (this.maxConnectionPerHost == -1 || size < this.maxConnectionPerHost) {
            IdleChannel idleChannel = new IdleChannel(uri, channel);
            ConcurrentLinkedQueue<IdleChannel> concurrentLinkedQueue = idleConnectionForHost;
            synchronized (concurrentLinkedQueue) {
                added = idleConnectionForHost.add(idleChannel);
                if (this.channel2IdleChannel.put(channel, idleChannel) != null) {
                    log.error("Channel {} already exists in the connections pool!", (Object)channel);
                }
            }
        } else {
            log.debug("Maximum number of requests per host reached {} for {}", (Object)this.maxConnectionPerHost, (Object)uri);
            added = false;
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel poll(String uri) {
        if (!this.sslConnectionPoolEnabled && uri.startsWith("https")) {
            return null;
        }
        IdleChannel idleChannel = null;
        ConcurrentLinkedQueue<IdleChannel> idleConnectionForHost = this.connectionsPool.get(uri);
        if (idleConnectionForHost != null) {
            boolean poolEmpty = false;
            while (!poolEmpty && idleChannel == null) {
                if (idleConnectionForHost.size() > 0) {
                    ConcurrentLinkedQueue<IdleChannel> concurrentLinkedQueue = idleConnectionForHost;
                    synchronized (concurrentLinkedQueue) {
                        idleChannel = idleConnectionForHost.poll();
                        if (idleChannel != null) {
                            this.channel2IdleChannel.remove(idleChannel.channel);
                        }
                    }
                }
                if (idleChannel == null) {
                    poolEmpty = true;
                    continue;
                }
                if (idleChannel.channel.isConnected() && idleChannel.channel.isOpen()) continue;
                idleChannel = null;
                log.trace("Channel not connected or not opened!");
            }
        }
        return idleChannel != null ? idleChannel.channel : null;
    }

    private boolean remove(IdleChannel pooledChannel) {
        if (pooledChannel == null || this.isClosed.get()) {
            return false;
        }
        boolean isRemoved = false;
        ConcurrentLinkedQueue<IdleChannel> pooledConnectionForHost = this.connectionsPool.get(pooledChannel.uri);
        if (pooledConnectionForHost != null) {
            isRemoved = pooledConnectionForHost.remove(pooledChannel);
        }
        return isRemoved |= this.channel2IdleChannel.remove(pooledChannel.channel) != null;
    }

    @Override
    public boolean removeAll(Channel channel) {
        return !this.isClosed.get() && this.remove(this.channel2IdleChannel.get(channel));
    }

    @Override
    public boolean canCacheConnection() {
        return this.isClosed.get() || this.maxTotalConnections == -1 || this.channel2IdleChannel.size() < this.maxTotalConnections;
    }

    @Override
    public void destroy() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.idleConnectionDetector.cancel();
        this.idleConnectionDetector.purge();
        for (Channel channel : this.channel2IdleChannel.keySet()) {
            this.close(channel);
        }
        this.connectionsPool.clear();
        this.channel2IdleChannel.clear();
    }

    private void close(Channel channel) {
        try {
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(new NettyAsyncHttpProvider.DiscardEvent());
            channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final String toString() {
        return String.format("NettyConnectionPool: {pool-size: %d}", this.channel2IdleChannel.size());
    }

    private class IdleChannelDetector
    extends TimerTask {
        private IdleChannelDetector() {
        }

        public void run() {
            try {
                if (NettyConnectionsPool.this.isClosed.get()) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    Set keys = NettyConnectionsPool.this.connectionsPool.keySet();
                    for (String s : keys) {
                        log.debug("Entry count for : {} : {}", (Object)s, (Object)((ConcurrentLinkedQueue)NettyConnectionsPool.this.connectionsPool.get(s)).size());
                    }
                }
                ArrayList<IdleChannel> channelsInTimeout = new ArrayList<IdleChannel>();
                long currentTime = DateUtil.millisTime();
                for (IdleChannel idleChannel : NettyConnectionsPool.this.channel2IdleChannel.values()) {
                    long age = currentTime - idleChannel.start;
                    if (age <= NettyConnectionsPool.this.maxIdleTime) continue;
                    log.debug("Adding Candidate Idle Channel {}", (Object)idleChannel.channel);
                    channelsInTimeout.add(idleChannel);
                }
                long endConcurrentLoop = DateUtil.millisTime();
                for (IdleChannel idleChannel : channelsInTimeout) {
                    NettyResponseFuture future;
                    Object attachment = idleChannel.channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment();
                    if (attachment != null && NettyResponseFuture.class.isAssignableFrom(attachment.getClass()) && !(future = (NettyResponseFuture)attachment).isDone() && !future.isCancelled()) {
                        log.debug("Future not in appropriate state %s\n", (Object)future);
                        continue;
                    }
                    if (!NettyConnectionsPool.this.remove(idleChannel)) continue;
                    log.debug("Closing Idle Channel {}", (Object)idleChannel.channel);
                    NettyConnectionsPool.this.close(idleChannel.channel);
                }
                if (log.isTraceEnabled()) {
                    int openChannels = 0;
                    for (ConcurrentLinkedQueue hostChannels : NettyConnectionsPool.this.connectionsPool.values()) {
                        openChannels += hostChannels.size();
                    }
                    log.trace(String.format("%d channel open, %d idle channels closed (times: 1st-loop=%d, 2nd-loop=%d).\n", openChannels, channelsInTimeout.size(), endConcurrentLoop - currentTime, DateUtil.millisTime() - endConcurrentLoop));
                }
            }
            catch (Throwable t) {
                log.error("uncaught exception!", t);
            }
        }
    }

    private static class IdleChannel {
        final String uri;
        final Channel channel;
        final long start;

        IdleChannel(String uri, Channel channel) {
            this.uri = uri;
            this.channel = channel;
            this.start = DateUtil.millisTime();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdleChannel)) {
                return false;
            }
            IdleChannel that = (IdleChannel)o;
            return !(this.channel != null ? !this.channel.equals(that.channel) : that.channel != null);
        }

        public int hashCode() {
            return this.channel != null ? this.channel.hashCode() : 0;
        }
    }
}

