/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.scoreboard;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public class Team {
    @NonNull
    private final String name;
    private String displayName;
    private String prefix;
    private String suffix;
    private boolean friendlyFire;
    private Set<String> players = new HashSet<String>();

    public Collection<String> getPlayers() {
        return Collections.unmodifiableSet(this.players);
    }

    public void addPlayer(String name) {
        this.players.add(name);
    }

    public void removePlayer(String name) {
        this.players.remove(name);
    }

    @ConstructorProperties(value={"name"})
    public Team(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    public void setPlayers(Set<String> players) {
        this.players = players;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Team)) {
            return false;
        }
        Team other = (Team)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        if (this.isFriendlyFire() != other.isFriendlyFire()) {
            return false;
        }
        Collection<String> this$players = this.getPlayers();
        Collection<String> other$players = other.getPlayers();
        return !(this$players == null ? other$players != null : !((Object)this$players).equals(other$players));
    }

    public boolean canEqual(Object other) {
        return other instanceof Team;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 31 + ($displayName == null ? 0 : $displayName.hashCode());
        String $prefix = this.getPrefix();
        result = result * 31 + ($prefix == null ? 0 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 31 + ($suffix == null ? 0 : $suffix.hashCode());
        result = result * 31 + (this.isFriendlyFire() ? 1231 : 1237);
        Collection<String> $players = this.getPlayers();
        result = result * 31 + ($players == null ? 0 : ((Object)$players).hashCode());
        return result;
    }

    public String toString() {
        return "Team(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", friendlyFire=" + this.isFriendlyFire() + ", players=" + this.getPlayers() + ")";
    }
}

