/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.reconnect;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.reconnect.AbstractReconnectManager;

public class SQLReconnectHandler
extends AbstractReconnectManager {
    private final Connection connection;

    public SQLReconnectHandler() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:bungee.sqlite");
        try (PreparedStatement ps = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS players (playerId INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,username TEXT NOT NULL UNIQUE COLLATE NOCASE,seen INTEGER,server TEXT);");){
            ps.executeUpdate();
        }
    }

    @Override
    protected String getStoredServer(ProxiedPlayer player) {
        String server;
        block39: {
            server = null;
            try (PreparedStatement ps = this.connection.prepareStatement("SELECT server FROM players WHERE username = ?");){
                ps.setString(1, player.getName());
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        server = rs.getString(1);
                        break block39;
                    }
                    try (PreparedStatement playerUpdate = this.connection.prepareStatement("INSERT INTO players( username ) VALUES( ? )");){
                        playerUpdate.setString(1, player.getName());
                        playerUpdate.executeUpdate();
                    }
                }
            }
            catch (SQLException ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load location for player " + player.getName(), ex);
            }
        }
        return server;
    }

    @Override
    public void setServer(ProxiedPlayer player) {
        try (PreparedStatement ps = this.connection.prepareStatement("UPDATE players SET server = ? WHERE username = ?");){
            ps.setString(1, player.getServer().getInfo().getName());
            ps.setString(2, player.getName());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not save location for player " + player.getName() + " on server " + player.getServer().getInfo().getName(), ex);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException ex) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Error closing SQLite connection", ex);
        }
    }
}

