/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.BufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToByteDecoder;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.Snappy;
import java.util.Arrays;

public class SnappyFramedDecoder
extends ByteToByteDecoder {
    private static final byte[] SNAPPY = new byte[]{115, 78, 97, 80, 112, 89};
    private final Snappy snappy = new Snappy();
    private final boolean validateChecksums;
    private boolean started;
    private boolean corrupted;

    public SnappyFramedDecoder() {
        this(false);
    }

    public SnappyFramedDecoder(boolean validateChecksums) {
        this.validateChecksums = validateChecksums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        if (this.corrupted) {
            in.skipBytes(in.readableBytes());
            return;
        }
        try {
            idx = in.readerIndex();
            inSize = in.writerIndex() - idx;
            if (inSize < 4) {
                return;
            }
            chunkTypeVal = in.getUnsignedByte(idx);
            chunkType = SnappyFramedDecoder.mapChunkType((byte)chunkTypeVal);
            chunkLength = BufUtil.swapMedium(in.getUnsignedMedium(idx + 1));
            switch (1.$SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType[chunkType.ordinal()]) {
                case 1: {
                    if (chunkLength != SnappyFramedDecoder.SNAPPY.length) {
                        throw new CompressionException("Unexpected length of stream identifier: " + chunkLength);
                    }
                    if (inSize < 4 + SnappyFramedDecoder.SNAPPY.length) break;
                    identifier = new byte[chunkLength];
                    in.skipBytes(4).readBytes(identifier);
                    if (!Arrays.equals(identifier, SnappyFramedDecoder.SNAPPY)) {
                        throw new CompressionException("Unexpected stream identifier contents. Mismatched snappy protocol version?");
                    }
                    this.started = true;
                    break;
                }
                case 2: {
                    if (!this.started) {
                        throw new CompressionException("Received RESERVED_SKIPPABLE tag before STREAM_IDENTIFIER");
                    }
                    if (inSize < 4 + chunkLength) {
                        return;
                    }
                    in.skipBytes(4 + chunkLength);
                    break;
                }
                case 3: {
                    throw new CompressionException("Found reserved unskippable chunk type: 0x" + Integer.toHexString(chunkTypeVal));
                }
                case 4: {
                    if (!this.started) {
                        throw new CompressionException("Received UNCOMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (chunkLength > 65540) {
                        throw new CompressionException("Received UNCOMPRESSED_DATA larger than 65540 bytes");
                    }
                    if (inSize < 4 + chunkLength) {
                        return;
                    }
                    in.skipBytes(4);
                    if (this.validateChecksums) {
                        checksum = BufUtil.swapInt(in.readInt());
                        Snappy.validateChecksum(checksum, in, in.readerIndex(), chunkLength - 4);
                    } else {
                        in.skipBytes(4);
                    }
                    out.writeBytes(in, chunkLength - 4);
                    break;
                }
                case 5: {
                    if (!this.started) {
                        throw new CompressionException("Received COMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (inSize < 4 + chunkLength) {
                        return;
                    }
                    in.skipBytes(4);
                    checksum = BufUtil.swapInt(in.readInt());
                    if (!this.validateChecksums) ** GOTO lbl76
                    oldWriterIndex = in.writerIndex();
                    uncompressedStart = out.writerIndex();
                    try {
                        in.writerIndex(in.readerIndex() + chunkLength - 4);
                        this.snappy.decode(in, out);
                    }
                    finally {
                        in.writerIndex(oldWriterIndex);
                    }
                    uncompressedLength = out.writerIndex() - uncompressedStart;
                    Snappy.validateChecksum(checksum, out, uncompressedStart, uncompressedLength);
                    ** GOTO lbl77
lbl76:
                    // 1 sources

                    this.snappy.decode(in.readSlice(chunkLength - 4), out);
lbl77:
                    // 2 sources

                    this.snappy.reset();
                }
            }
        }
        catch (Exception e) {
            this.corrupted = true;
            throw e;
        }
    }

    static ChunkType mapChunkType(byte type) {
        if (type == 0) {
            return ChunkType.COMPRESSED_DATA;
        }
        if (type == 1) {
            return ChunkType.UNCOMPRESSED_DATA;
        }
        if (type == -128) {
            return ChunkType.STREAM_IDENTIFIER;
        }
        if ((type & 0x80) == 128) {
            return ChunkType.RESERVED_SKIPPABLE;
        }
        return ChunkType.RESERVED_UNSKIPPABLE;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType;

        static {
            $SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType = new int[ChunkType.values().length];
            try {
                1.$SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType[ChunkType.STREAM_IDENTIFIER.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType[ChunkType.RESERVED_SKIPPABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType[ChunkType.RESERVED_UNSKIPPABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType[ChunkType.UNCOMPRESSED_DATA.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType[ChunkType.COMPRESSED_DATA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static enum ChunkType {
        STREAM_IDENTIFIER,
        COMPRESSED_DATA,
        UNCOMPRESSED_DATA,
        RESERVED_UNSKIPPABLE,
        RESERVED_SKIPPABLE;

    }
}

