/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginClassloader;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.event.EventBus;
import net.md_5.bungee.event.EventHandler;
import org.yaml.snakeyaml.Yaml;

public class PluginManager {
    private static final Pattern argsSplit = Pattern.compile(" ");
    private final ProxyServer proxy;
    private final Yaml yaml = new Yaml();
    private final EventBus eventBus;
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
    private final Map<String, Command> commandMap = new HashMap<String, Command>();

    public PluginManager(ProxyServer proxy) {
        this.proxy = proxy;
        this.eventBus = new EventBus(proxy.getLogger(), Subscribe.class, EventHandler.class);
    }

    public void registerCommand(Plugin plugin, Command command) {
        this.commandMap.put(command.getName().toLowerCase(), command);
        for (String alias : command.getAliases()) {
            this.commandMap.put(alias.toLowerCase(), command);
        }
    }

    public void unregisterCommand(Command command) {
        this.commandMap.values().remove(command);
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        String[] split = argsSplit.split(commandLine);
        Command command = this.commandMap.get(split[0].toLowerCase());
        if (command == null) {
            return false;
        }
        String permission = command.getPermission();
        if (permission != null && !permission.isEmpty() && !sender.hasPermission(permission)) {
            sender.sendMessage(this.proxy.getTranslation("no_permission"));
            return true;
        }
        String[] args = Arrays.copyOfRange(split, 1, split.length);
        try {
            command.execute(sender, args);
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "An internal error occurred whilst executing this command, please check the console log for details.");
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Error in dispatching command", ex);
        }
        return true;
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    public Plugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public void enablePlugins() {
        HashMap<Plugin, Boolean> pluginStatuses = new HashMap<Plugin, Boolean>();
        for (Map.Entry<String, Plugin> entry : this.plugins.entrySet()) {
            Plugin plugin = entry.getValue();
            if (this.enablePlugin(pluginStatuses, new Stack<Plugin>(), plugin)) continue;
            ProxyServer.getInstance().getLogger().warning("Failed to enable " + entry.getKey());
        }
    }

    private boolean enablePlugin(Map<Plugin, Boolean> pluginStatuses, Stack<Plugin> dependStack, Plugin plugin) {
        if (pluginStatuses.containsKey(plugin)) {
            return pluginStatuses.get(plugin);
        }
        boolean status = true;
        for (String dependName : plugin.getDescription().getDepends()) {
            Boolean dependStatus;
            Plugin depend = this.plugins.get(dependName);
            Boolean bl = dependStatus = depend != null ? pluginStatuses.get(depend) : Boolean.FALSE;
            if (dependStatus == null) {
                if (dependStack.contains(depend)) {
                    StringBuilder dependencyGraph = new StringBuilder();
                    for (Plugin element : dependStack) {
                        dependencyGraph.append(element.getDescription().getName()).append(" -> ");
                    }
                    dependencyGraph.append(plugin.getDescription().getName()).append(" -> ").append(dependName);
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "Circular dependency detected: " + dependencyGraph);
                    status = false;
                } else {
                    dependStack.push(plugin);
                    dependStatus = this.enablePlugin(pluginStatuses, dependStack, depend);
                    dependStack.pop();
                }
            }
            if (dependStatus == Boolean.FALSE) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} (required by {1}) is unavailable", new Object[]{depend.getDescription().getName(), plugin.getDescription().getName()});
                status = false;
            }
            if (status) continue;
            break;
        }
        if (status) {
            try {
                plugin.onEnable();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Enabled plugin {0} version {1} by {2}", new Object[]{plugin.getDescription().getName(), plugin.getDescription().getVersion(), plugin.getDescription().getAuthor()});
            }
            catch (Throwable t) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Exception encountered when loading plugin: " + plugin.getDescription().getName(), t);
                status = false;
            }
        }
        pluginStatuses.put(plugin, status);
        return status;
    }

    public void loadPlugin(File file) throws Exception {
        Preconditions.checkNotNull(file, "file");
        Preconditions.checkArgument(file.isFile(), "Must load from file");
        try (JarFile jar = new JarFile(file);){
            JarEntry pdf = jar.getJarEntry("plugin.yml");
            Preconditions.checkNotNull(pdf, "Plugin must have a plugin.yml");
            try (InputStream in = jar.getInputStream(pdf);){
                PluginDescription desc = this.yaml.loadAs(in, PluginDescription.class);
                PluginClassloader loader = new PluginClassloader(new URL[]{file.toURI().toURL()});
                Class<?> main = loader.loadClass(desc.getMain());
                Plugin plugin = (Plugin)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.init(this.proxy, desc, file);
                this.plugins.put(desc.getName(), plugin);
                plugin.onLoad();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Loaded plugin {0} version {1} by {2}", new Object[]{desc.getName(), desc.getVersion(), desc.getAuthor()});
            }
        }
    }

    public void loadPlugins(File folder) {
        Preconditions.checkNotNull(folder, "folder");
        Preconditions.checkArgument(folder.isDirectory(), "Must load from a directory");
        for (File file : folder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try {
                this.loadPlugin(file);
            }
            catch (Exception ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load plugin from file " + file, ex);
            }
        }
    }

    public <T extends Event> T callEvent(T event) {
        Preconditions.checkNotNull(event, "event");
        long start = System.nanoTime();
        this.eventBus.post(event);
        event.postCall();
        long elapsed = start - System.nanoTime();
        if (elapsed > 250000L) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Event {0} took more {1}ns to process!", new Object[]{event, elapsed});
        }
        return event;
    }

    public void registerListener(Plugin plugin, Listener listener) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            this.proxy.getLogger().log(Level.WARNING, "Listener {0} has registered using depreceated subscribe annotation! Please advice author to update to @EventHandler. As a server owner you may safely ignore this.", listener);
        }
        this.eventBus.register(listener);
    }

    @ConstructorProperties(value={"proxy", "eventBus"})
    public PluginManager(ProxyServer proxy, EventBus eventBus) {
        this.proxy = proxy;
        this.eventBus = eventBus;
    }
}

