/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.buffer.BufType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFlushPromiseNotifier;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.aio.AbstractAioChannel;
import io.netty.channel.aio.AioCompletionHandler;
import io.netty.channel.aio.AioEventLoopGroup;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.aio.AioServerSocketChannel;
import io.netty.channel.socket.aio.AioSocketChannelConfig;
import io.netty.channel.socket.aio.DefaultAioSocketChannelConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;

public class AioSocketChannel
extends AbstractAioChannel
implements SocketChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(BufType.BYTE, false);
    private static final CompletionHandler<Void, AioSocketChannel> CONNECT_HANDLER = new ConnectHandler();
    private static final CompletionHandler<Integer, AioSocketChannel> WRITE_HANDLER = new WriteHandler<Integer>();
    private static final CompletionHandler<Integer, AioSocketChannel> READ_HANDLER = new ReadHandler<Integer>();
    private static final CompletionHandler<Long, AioSocketChannel> GATHERING_WRITE_HANDLER = new WriteHandler<Long>();
    private static final CompletionHandler<Long, AioSocketChannel> SCATTERING_READ_HANDLER = new ReadHandler<Long>();
    private final DefaultAioSocketChannelConfig config;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private boolean readInProgress;
    private boolean inDoBeginRead;
    private boolean readAgain;
    private static final int NO_WRITE_IN_PROGRESS = 0;
    private static final int WRITE_IN_PROGRESS = 1;
    private static final int WRITE_FAILED = -2;
    private int writeInProgress;
    private boolean inDoFlushByteBuffer;

    private static AsynchronousSocketChannel newSocket(AsynchronousChannelGroup group) {
        try {
            return AsynchronousSocketChannel.open(group);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    public AioSocketChannel() {
        this(null, null, null);
    }

    AioSocketChannel(AioServerSocketChannel parent, Integer id, AsynchronousSocketChannel ch) {
        super(parent, id, ch);
        this.config = new DefaultAioSocketChannelConfig(this, ch);
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public boolean isActive() {
        return this.ch != null && this.javaChannel().isOpen() && this.remoteAddress0() != null;
    }

    @Override
    protected AsynchronousSocketChannel javaChannel() {
        return (AsynchronousSocketChannel)super.javaChannel();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise promise) {
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            try {
                this.javaChannel().shutdownOutput();
                this.outputShutdown = true;
                promise.setSuccess();
            }
            catch (Throwable t) {
                promise.setFailure(t);
            }
        } else {
            loop.execute(new Runnable(){

                @Override
                public void run() {
                    AioSocketChannel.this.shutdownOutput(promise);
                }
            });
        }
        return promise;
    }

    @Override
    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        if (localAddress != null) {
            try {
                this.javaChannel().bind(localAddress);
            }
            catch (IOException e) {
                promise.setFailure(e);
                return;
            }
        }
        this.javaChannel().connect(remoteAddress, this, CONNECT_HANDLER);
    }

    @Override
    protected InetSocketAddress localAddress0() {
        if (this.ch == null) {
            return null;
        }
        try {
            return (InetSocketAddress)this.javaChannel().getLocalAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected InetSocketAddress remoteAddress0() {
        if (this.ch == null) {
            return null;
        }
        try {
            return (InetSocketAddress)this.javaChannel().getRemoteAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Runnable doRegister() throws Exception {
        super.doRegister();
        if (this.ch == null) {
            this.ch = AioSocketChannel.newSocket(((AioEventLoopGroup)this.eventLoop().parent()).channelGroup());
            this.config.assign(this.javaChannel());
        }
        return null;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.javaChannel().bind(localAddress);
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.javaChannel().close();
        this.inputShutdown = true;
        this.outputShutdown = true;
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        block14: {
            if (this.inDoFlushByteBuffer || this.writeInProgress != 0) {
                return;
            }
            this.inDoFlushByteBuffer = true;
            try {
                if (buf.isReadable()) {
                    do {
                        if (buf.refCnt() == 0) {
                        } else {
                            buf.discardReadBytes();
                            this.writeInProgress = 1;
                            if (buf.nioBufferCount() == 1) {
                                this.javaChannel().write(buf.nioBuffer(), this.config.getWriteTimeout(), TimeUnit.MILLISECONDS, this, WRITE_HANDLER);
                            } else {
                                ByteBuffer[] buffers = buf.nioBuffers(buf.readerIndex(), buf.readableBytes());
                                if (buffers.length == 1) {
                                    this.javaChannel().write(buffers[0], this.config.getWriteTimeout(), TimeUnit.MILLISECONDS, this, WRITE_HANDLER);
                                } else {
                                    this.javaChannel().write(buffers, 0, buffers.length, this.config.getWriteTimeout(), TimeUnit.MILLISECONDS, this, GATHERING_WRITE_HANDLER);
                                }
                            }
                            if (this.writeInProgress == 0) continue;
                            if (this.writeInProgress == -2) {
                                this.writeInProgress = 0;
                            } else {
                                buf.suspendIntermediaryDeallocations();
                            }
                        }
                        break block14;
                    } while (buf.isReadable());
                    break block14;
                }
                this.flushFutureNotifier.notifyFlushFutures();
            }
            finally {
                this.inDoFlushByteBuffer = false;
            }
        }
    }

    @Override
    protected void doFlushFileRegion(AbstractChannel.FlushTask task) throws Exception {
        task.region().transferTo(new WritableByteChannelAdapter(task), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBeginRead() {
        if (this.inDoBeginRead) {
            this.readAgain = true;
            return;
        }
        if (this.readInProgress || this.inputShutdown) {
            return;
        }
        this.inDoBeginRead = true;
        try {
            while (true) {
                if (this.inputShutdown) {
                } else {
                    ByteBuf byteBuf = this.pipeline().inboundByteBuffer();
                    AioSocketChannel.expandReadBuffer(byteBuf);
                    this.readInProgress = true;
                    if (byteBuf.nioBufferCount() == 1) {
                        ByteBuffer buffer = byteBuf.nioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
                        this.javaChannel().read(buffer, this.config.getReadTimeout(), TimeUnit.MILLISECONDS, this, READ_HANDLER);
                    } else {
                        ByteBuffer[] buffers = byteBuf.nioBuffers(byteBuf.writerIndex(), byteBuf.writableBytes());
                        if (buffers.length == 1) {
                            this.javaChannel().read(buffers[0], this.config.getReadTimeout(), TimeUnit.MILLISECONDS, this, READ_HANDLER);
                        } else {
                            this.javaChannel().read(buffers, 0, buffers.length, this.config.getReadTimeout(), TimeUnit.MILLISECONDS, this, SCATTERING_READ_HANDLER);
                        }
                    }
                    if (this.readInProgress) {
                    } else if (this.readAgain) {
                        this.readAgain = false;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.inDoBeginRead = false;
        }
    }

    @Override
    public AioSocketChannelConfig config() {
        return this.config;
    }

    private final class WritableByteChannelAdapter
    implements WritableByteChannel {
        private final AbstractChannel.FlushTask task;
        private long written;

        public WritableByteChannelAdapter(AbstractChannel.FlushTask task) {
            this.task = task;
        }

        @Override
        public int write(final ByteBuffer src) {
            AioSocketChannel.this.javaChannel().write(src, AioSocketChannel.this, new AioCompletionHandler<Integer, Channel>(){

                @Override
                public void completed0(Integer result, Channel attachment) {
                    try {
                        if (result == 0) {
                            AioSocketChannel.this.javaChannel().write(src, AioSocketChannel.this, this);
                            return;
                        }
                        if (result == -1) {
                            AioSocketChannel.checkEOF(WritableByteChannelAdapter.this.task.region(), WritableByteChannelAdapter.this.written);
                            WritableByteChannelAdapter.this.task.setSuccess();
                            return;
                        }
                        WritableByteChannelAdapter.this.written += result.intValue();
                        WritableByteChannelAdapter.this.task.setProgress(WritableByteChannelAdapter.this.written);
                        if (WritableByteChannelAdapter.this.written >= WritableByteChannelAdapter.this.task.region().count()) {
                            WritableByteChannelAdapter.this.task.setSuccess();
                            return;
                        }
                        if (src.hasRemaining()) {
                            AioSocketChannel.this.javaChannel().write(src, AioSocketChannel.this, this);
                        } else {
                            WritableByteChannelAdapter.this.task.region().transferTo(WritableByteChannelAdapter.this, WritableByteChannelAdapter.this.written);
                        }
                    }
                    catch (Throwable cause) {
                        WritableByteChannelAdapter.this.task.setFailure(cause);
                    }
                }

                @Override
                public void failed0(Throwable exc, Channel attachment) {
                    WritableByteChannelAdapter.this.task.setFailure(exc);
                }
            });
            return 0;
        }

        @Override
        public boolean isOpen() {
            return AioSocketChannel.this.javaChannel().isOpen();
        }

        @Override
        public void close() throws IOException {
            AioSocketChannel.this.javaChannel().close();
        }
    }

    private static final class ConnectHandler
    extends AioCompletionHandler<Void, AioSocketChannel> {
        private ConnectHandler() {
        }

        @Override
        protected void completed0(Void result, AioSocketChannel channel) {
            ((AbstractAioChannel.DefaultAioUnsafe)channel.unsafe()).connectSuccess();
        }

        @Override
        protected void failed0(Throwable exc, AioSocketChannel channel) {
            ((AbstractAioChannel.DefaultAioUnsafe)channel.unsafe()).connectFailed(exc);
        }
    }

    private static final class ReadHandler<T extends Number>
    extends AioCompletionHandler<T, AioSocketChannel> {
        private ReadHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void completed0(T result, AioSocketChannel channel) {
            channel.readInProgress = false;
            if (channel.inputShutdown) {
                return;
            }
            ChannelPipeline pipeline = channel.pipeline();
            ByteBuf byteBuf = pipeline.inboundByteBuffer();
            boolean closed = false;
            boolean read = false;
            boolean firedChannelReadSuspended = false;
            try {
                int localReadAmount = ((Number)result).intValue();
                if (localReadAmount > 0) {
                    byteBuf.writerIndex(byteBuf.writerIndex() + localReadAmount);
                    read = true;
                } else if (localReadAmount < 0) {
                    closed = true;
                }
            }
            catch (Throwable t) {
                if (read) {
                    read = false;
                    pipeline.fireInboundBufferUpdated();
                }
                if (!closed && channel.isOpen()) {
                    firedChannelReadSuspended = true;
                    pipeline.fireChannelReadSuspended();
                }
                pipeline.fireExceptionCaught(t);
            }
            finally {
                if (read) {
                    pipeline.fireInboundBufferUpdated();
                }
                if (closed || !channel.isOpen()) {
                    channel.inputShutdown = true;
                    if (channel.isOpen()) {
                        if (channel.config().isAllowHalfClosure()) {
                            pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                        } else {
                            channel.unsafe().close(channel.voidPromise());
                        }
                    }
                } else if (!firedChannelReadSuspended) {
                    pipeline.fireChannelReadSuspended();
                }
            }
        }

        @Override
        protected void failed0(Throwable t, AioSocketChannel channel) {
            channel.readInProgress = false;
            if (t instanceof ClosedChannelException) {
                channel.inputShutdown = true;
                return;
            }
            channel.pipeline().fireExceptionCaught(t);
            if (t instanceof IOException || t instanceof InterruptedByTimeoutException) {
                channel.unsafe().close(channel.voidPromise());
            }
        }
    }

    private static final class WriteHandler<T extends Number>
    extends AioCompletionHandler<T, AioSocketChannel> {
        private WriteHandler() {
        }

        @Override
        protected void completed0(T result, AioSocketChannel channel) {
            channel.writeInProgress = 0;
            ByteBuf buf = channel.unsafe().headContext().outboundByteBuffer();
            if (buf.refCnt() == 0) {
                return;
            }
            buf.resumeIntermediaryDeallocations();
            int writtenBytes = ((Number)result).intValue();
            if (writtenBytes > 0) {
                buf.readerIndex(buf.readerIndex() + writtenBytes);
            }
            if (channel.inDoFlushByteBuffer) {
                return;
            }
            ChannelFlushPromiseNotifier notifier = channel.flushFutureNotifier;
            notifier.increaseWriteCounter(writtenBytes);
            notifier.notifyFlushFutures();
            if (!channel.isActive()) {
                return;
            }
            if (buf.isReadable()) {
                channel.unsafe().flushNow();
            }
        }

        @Override
        protected void failed0(Throwable cause, AioSocketChannel channel) {
            channel.writeInProgress = -2;
            channel.flushFutureNotifier.notifyFlushFutures(cause);
            if (cause instanceof InterruptedByTimeoutException) {
                channel.unsafe().close(channel.voidPromise());
            }
        }
    }
}

