/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.event.EventHandler;

public class EventBus {
    private final Map<Class<?>, Map<Object, Method[]>> eventToHandler = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Logger logger;
    private final Class<? extends Annotation>[] annotations;

    public EventBus() {
        this((Logger)null, (Class<? extends Annotation>[])null);
    }

    public EventBus(Logger logger) {
        this(logger, (Class[])null);
    }

    public EventBus(Class<? extends Annotation> ... annotations) {
        this((Logger)null, annotations);
    }

    public EventBus(Logger logger, Class<? extends Annotation> ... annotations) {
        Class[] classArray;
        Logger logger2 = this.logger = logger == null ? Logger.getGlobal() : logger;
        if (annotations == null || annotations.length == 0) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = EventHandler.class;
        } else {
            classArray = annotations;
        }
        this.annotations = classArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object event) {
        this.lock.readLock().lock();
        try {
            Map<Object, Method[]> handlers = this.eventToHandler.get(event.getClass());
            if (handlers != null) {
                for (Map.Entry<Object, Method[]> handler : handlers.entrySet()) {
                    for (Method method : handler.getValue()) {
                        try {
                            method.invoke(handler.getKey(), event);
                        }
                        catch (IllegalAccessException ex) {
                            throw new Error("Method became inaccessible: " + event, ex);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new Error("Method rejected target/argument: " + event, ex);
                        }
                        catch (InvocationTargetException ex) {
                            this.logger.log(Level.WARNING, MessageFormat.format("Error dispatching event {0} to listener {1}", event, handler.getKey()), ex.getCause());
                        }
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<Class<?>, Set<Method>> findHandlers(Object listener) {
        HashMap handler = new HashMap();
        block0: for (Method m : listener.getClass().getDeclaredMethods()) {
            for (Class<? extends Annotation> annotation : this.annotations) {
                if (!m.isAnnotationPresent(annotation)) continue;
                Class<?>[] params = m.getParameterTypes();
                if (params.length != 1) {
                    this.logger.log(Level.INFO, "Method {0} in class {1} annotated with {2} does not have single argument", new Object[]{m, listener.getClass(), annotation});
                    continue;
                }
                HashSet<Method> existing = (HashSet<Method>)handler.get(params[0]);
                if (existing == null) {
                    existing = new HashSet<Method>();
                    handler.put(params[0], existing);
                }
                existing.add(m);
                continue block0;
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object listener) {
        Map<Class<?>, Set<Method>> handler = this.findHandlers(listener);
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<Class<?>, Set<Method>> e : handler.entrySet()) {
                Map<Object, Method[]> a = this.eventToHandler.get(e.getKey());
                if (a == null) {
                    a = new HashMap<Object, Method[]>();
                    this.eventToHandler.put(e.getKey(), a);
                }
                Method[] baked = new Method[e.getValue().size()];
                a.put(listener, e.getValue().toArray(baked));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Object listener) {
        Map<Class<?>, Set<Method>> handler = this.findHandlers(listener);
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<Class<?>, Set<Method>> e : handler.entrySet()) {
                Map<Object, Method[]> a = this.eventToHandler.get(e.getKey());
                if (a == null) continue;
                a.remove(listener);
                if (!a.isEmpty()) continue;
                this.eventToHandler.remove(e.getKey());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

