/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.PacketFAPluginMessage;

public class BungeeServerInfo
implements ServerInfo {
    private final String name;
    private final InetSocketAddress address;
    private final Collection<ProxiedPlayer> players = new ArrayList<ProxiedPlayer>();
    private final boolean restricted;
    private final Queue<DefinedPacket> packetQueue = new LinkedList<DefinedPacket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.add(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.players);
        }
    }

    @Override
    public boolean canAccess(CommandSender player) {
        return !this.restricted || player.hasPermission("bungeecord.server." + this.name);
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerInfo && Objects.equals(this.getAddress(), ((ServerInfo)obj).getAddress());
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendData(String channel, byte[] data) {
        Server server = ProxyServer.getInstance().getServer(this.getName());
        if (server != null) {
            server.sendData(channel, data);
        } else {
            Queue<DefinedPacket> queue = this.packetQueue;
            synchronized (queue) {
                this.packetQueue.add(new PacketFAPluginMessage(channel, data));
            }
        }
    }

    @Override
    public void ping(final Callback<ServerPing> callback) {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(BungeeCord.getInstance().eventLoops)).handler(PipelineUtils.BASE)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).remoteAddress(this.getAddress()).connect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    future.channel().pipeline().get(HandlerBoss.class).setHandler(new PingHandler(BungeeServerInfo.this, callback));
                } else {
                    callback.done(null, future.cause());
                }
            }
        });
    }

    @ConstructorProperties(value={"name", "address", "restricted"})
    public BungeeServerInfo(String name, InetSocketAddress address, boolean restricted) {
        this.name = name;
        this.address = address;
        this.restricted = restricted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public Queue<DefinedPacket> getPacketQueue() {
        return this.packetQueue;
    }
}

