/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PermissionCheckEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.scoreboard.Scoreboard;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketCCSettings;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFFKick;

public final class UserConnection
implements ProxiedPlayer {
    private final ProxyServer bungee;
    private final ChannelWrapper ch;
    private final String name;
    private final InitialHandler pendingConnection;
    private ServerConnection server;
    public int clientEntityId;
    public int serverEntityId;
    public int trackingPingId;
    public long pingTime;
    private String displayName;
    private int ping = 1000;
    private final Collection<String> groups = new HashSet<String>();
    private final Collection<String> permissions = new HashSet<String>();
    private final Object switchMutex = new Object();
    public PacketCCSettings settings;
    public final Scoreboard serverSentScoreboard = new Scoreboard();
    public final Collection<ServerInfo> pendingConnects = new HashSet<ServerInfo>();

    public void init() {
        this.displayName = this.name;
        Collection<String> g = this.bungee.getConfigurationAdapter().getGroups(this.name);
        for (String s : g) {
            this.addGroups(s);
        }
    }

    public void sendPacket(DefinedPacket p) {
        this.ch.write(p);
    }

    public void sendPacket(byte[] b) {
        this.ch.write(b);
    }

    @Deprecated
    public boolean isActive() {
        return this.ch.getHandle().isActive();
    }

    @Override
    public void setDisplayName(String name) {
        Preconditions.checkNotNull(name, "displayName");
        Preconditions.checkArgument(name.length() <= 16, "Display name cannot be longer than 16 characters");
        this.bungee.getTabListHandler().onDisconnect(this);
        this.displayName = name;
        this.bungee.getTabListHandler().onConnect(this);
    }

    @Override
    public void connect(ServerInfo target) {
        this.connect(target, false);
    }

    public void connectNow(ServerInfo target) {
        this.sendPacket(Packet9Respawn.DIM1_SWITCH);
        this.sendPacket(Packet9Respawn.DIM2_SWITCH);
        this.connect(target);
    }

    public void connect(ServerInfo info, final boolean retry) {
        ServerConnectEvent event = new ServerConnectEvent(this, info);
        ProxyServer.getInstance().getPluginManager().callEvent(event);
        Preconditions.checkArgument(event.getTarget() instanceof BungeeServerInfo, "BungeeCord can only connect to BungeeServerInfo instances");
        final BungeeServerInfo target = (BungeeServerInfo)event.getTarget();
        if (this.getServer() != null && Objects.equals(this.getServer().getInfo(), target)) {
            this.sendMessage((Object)((Object)ChatColor.RED) + "Cannot connect to server you are already on!");
            return;
        }
        if (this.pendingConnects.contains(target)) {
            this.sendMessage((Object)((Object)ChatColor.RED) + "Already connecting to this server!");
            return;
        }
        this.pendingConnects.add(target);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(BungeeCord.getInstance().eventLoops)).handler(new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                PipelineUtils.BASE.initChannel(ch);
                ch.pipeline().get(HandlerBoss.class).setHandler(new ServerConnector(UserConnection.this.bungee, UserConnection.this, target));
            }
        })).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).remoteAddress(target.getAddress()).connect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    future.channel().close();
                    UserConnection.this.pendingConnects.remove(target);
                    ServerInfo def = ProxyServer.getInstance().getServers().get(UserConnection.this.getPendingConnection().getListener().getFallbackServer());
                    if (retry & target != def && (UserConnection.this.getServer() == null || def != UserConnection.this.getServer().getInfo())) {
                        UserConnection.this.sendMessage((Object)((Object)ChatColor.RED) + "Could not connect to target server, you have been moved to the lobby server");
                        UserConnection.this.connect(def, false);
                    } else if (UserConnection.this.server == null) {
                        UserConnection.this.disconnect("Could not connect to default server, please try again later: " + future.cause().getClass().getName());
                    } else {
                        UserConnection.this.sendMessage((Object)((Object)ChatColor.RED) + "Could not connect to selected server, please try again later: " + future.cause().getClass().getName());
                    }
                }
            }
        });
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (this.ch.getHandle().isActive()) {
            this.bungee.getLogger().log(Level.INFO, "[" + this.getName() + "] disconnected with: " + reason);
            this.sendPacket(new PacketFFKick(reason));
            this.ch.getHandle().close();
            if (this.server != null) {
                this.server.disconnect("Quitting");
            }
        }
    }

    @Override
    public void chat(String message) {
        Preconditions.checkState(this.server != null, "Not connected to server");
        this.server.getCh().write(new Packet3Chat(message));
    }

    @Override
    public void sendMessage(String message) {
        this.sendPacket(new Packet3Chat(message));
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.sendPacket(new PacketFAPluginMessage(channel, data));
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    @Override
    public Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    @Override
    public void addGroups(String ... groups) {
        for (String group : groups) {
            this.groups.add(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, true);
            }
        }
    }

    @Override
    public void removeGroups(String ... groups) {
        for (String group : groups) {
            this.groups.remove(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, false);
            }
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.bungee.getPluginManager().callEvent(new PermissionCheckEvent(this, permission, this.permissions.contains(permission))).hasPermission();
    }

    @Override
    public void setPermission(String permission, boolean value) {
        if (value) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    public String toString() {
        return this.name;
    }

    @ConstructorProperties(value={"bungee", "ch", "name", "pendingConnection"})
    public UserConnection(ProxyServer bungee, ChannelWrapper ch, String name, InitialHandler pendingConnection) {
        this.bungee = bungee;
        this.ch = ch;
        this.name = name;
        this.pendingConnection = pendingConnection;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InitialHandler getPendingConnection() {
        return this.pendingConnection;
    }

    @Override
    public ServerConnection getServer() {
        return this.server;
    }

    void setServer(ServerConnection server) {
        this.server = server;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    public Object getSwitchMutex() {
        return this.switchMutex;
    }
}

