/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractMessageBuf;
import io.netty.buffer.BufUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;

final class QueueBackedMessageBuf<T>
extends AbstractMessageBuf<T> {
    private Queue<T> queue;

    QueueBackedMessageBuf(Queue<T> queue) {
        super(Integer.MAX_VALUE);
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        this.queue = queue;
    }

    @Override
    public boolean offer(T e) {
        if (e == null) {
            throw new NullPointerException("e");
        }
        this.ensureAccessible();
        return this.isWritable() && this.queue.offer(e);
    }

    @Override
    public T poll() {
        this.ensureAccessible();
        return this.queue.poll();
    }

    @Override
    public T peek() {
        this.ensureAccessible();
        return this.queue.peek();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.ensureAccessible();
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        this.ensureAccessible();
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        this.ensureAccessible();
        return this.queue.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        this.ensureAccessible();
        return this.queue.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        this.ensureAccessible();
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.ensureAccessible();
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.ensureAccessible();
        return this.isWritable(c.size()) && this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.ensureAccessible();
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.ensureAccessible();
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.ensureAccessible();
        this.queue.clear();
    }

    @Override
    protected void deallocate() {
        for (Object e : this.queue) {
            BufUtil.release(e);
        }
        this.queue = null;
    }
}

