/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.CompressionException;
import java.util.zip.CRC32;

final class SnappyChecksumUtil {
    static void validateChecksum(ByteBuf slice, int checksum) {
        if (SnappyChecksumUtil.calculateChecksum(slice) != checksum) {
            throw new CompressionException("Uncompressed data did not match checksum");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateChecksum(ByteBuf slice) {
        CRC32 crc32 = new CRC32();
        try {
            byte[] array = new byte[slice.readableBytes()];
            slice.markReaderIndex();
            slice.readBytes(array);
            slice.resetReaderIndex();
            crc32.update(array);
            int n = SnappyChecksumUtil.maskChecksum((int)crc32.getValue());
            return n;
        }
        finally {
            crc32.reset();
        }
    }

    static int maskChecksum(int checksum) {
        return (checksum >> 15 | checksum << 17) + -1568478504;
    }

    private SnappyChecksumUtil() {
    }
}

