/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.base64;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.channel.ChannelOutboundMessageHandlerAdapter;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;

@ChannelHandler.Sharable
public class Base64Encoder
extends ChannelOutboundMessageHandlerAdapter<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    @Override
    public void flush(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ByteBuf buf = Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect);
        ChannelHandlerUtil.addToNextOutboundBuffer(ctx, buf);
    }
}

