/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.PacketHandler;

public class HandlerBoss
extends ChannelInboundMessageHandlerAdapter<byte[]> {
    private PacketHandler handler;

    public void setHandler(PacketHandler handler) {
        Preconditions.checkArgument(handler != null, "handler");
        this.handler = handler;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.handler.connected(ctx.channel());
            ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has connected", this.handler);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has disconnected", this.handler);
            this.handler.disconnected(ctx.channel());
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, byte[] msg) throws Exception {
        if (this.handler != null && ctx.channel().isActive()) {
            DefinedPacket packet = DefinedPacket.packet(msg);
            boolean sendPacket = true;
            if (packet != null) {
                try {
                    packet.handle(this.handler);
                }
                catch (CancelSendSignal ex) {
                    sendPacket = false;
                }
            }
            if (sendPacket) {
                this.handler.handle(msg);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            if (cause instanceof ReadTimeoutException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, this.handler + " - read timed out");
            } else if (cause instanceof IOException) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, this.handler + " - IOException: " + cause.getMessage());
            } else {
                ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - encountered exception", cause);
            }
            if (this.handler != null) {
                try {
                    this.handler.exception(cause);
                }
                catch (Exception ex) {
                    ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - exception processing exception", ex);
                }
            }
            ctx.close();
        }
    }
}

