/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.channel.socket.aio.AioServerSocketChannel;
import io.netty.util.NetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class AioServerSocketChannelConfig
extends DefaultChannelConfig
implements ServerSocketChannelConfig {
    private final AtomicReference<AsynchronousServerSocketChannel> javaChannel = new AtomicReference();
    private volatile int backlog = NetUtil.SOMAXCONN;
    private Map<SocketOption<?>, Object> options = PlatformDependent.newConcurrentHashMap();
    private static final int DEFAULT_SND_BUF_SIZE = 32768;
    private static final boolean DEFAULT_SO_REUSEADDR = false;

    AioServerSocketChannelConfig(AioServerSocketChannel channel) {
        super(channel);
    }

    AioServerSocketChannelConfig(AioServerSocketChannel channel, AsynchronousServerSocketChannel javaChannel) {
        super(channel);
        this.javaChannel.set(javaChannel);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG);
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) {
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_BACKLOG) {
            return (T)Integer.valueOf(this.getBacklog());
        }
        return super.getOption(option);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_BACKLOG) {
            this.setBacklog((Integer)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    @Override
    public boolean isReuseAddress() {
        return (Boolean)this.getOption(StandardSocketOptions.SO_REUSEADDR, false);
    }

    @Override
    public AioServerSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        this.setOption(StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddress);
        return this;
    }

    @Override
    public int getReceiveBufferSize() {
        return (Integer)this.getOption(StandardSocketOptions.SO_RCVBUF, 32768);
    }

    @Override
    public AioServerSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        this.setOption(StandardSocketOptions.SO_RCVBUF, (Object)receiveBufferSize);
        return this;
    }

    @Override
    public AioServerSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public AioServerSocketChannelConfig setBacklog(int backlog) {
        if (backlog < 0) {
            throw new IllegalArgumentException("backlog: " + backlog);
        }
        this.backlog = backlog;
        return this;
    }

    private Object getOption(SocketOption option, Object defaultValue) {
        if (this.javaChannel.get() == null) {
            Object value = this.options.get(option);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
        try {
            return this.javaChannel.get().getOption(option);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setOption(SocketOption option, Object defaultValue) {
        if (this.javaChannel.get() == null) {
            this.options.put(option, defaultValue);
            return;
        }
        try {
            this.javaChannel.get().setOption(option, defaultValue);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    void assign(AsynchronousServerSocketChannel javaChannel) {
        if (javaChannel == null) {
            throw new NullPointerException("javaChannel");
        }
        if (this.javaChannel.compareAndSet(null, javaChannel)) {
            this.propagateOptions();
        }
    }

    private void propagateOptions() {
        for (SocketOption<?> option : this.options.keySet()) {
            Object value = this.options.remove(option);
            if (value == null) continue;
            try {
                this.javaChannel.get().setOption((SocketOption)option, value);
            }
            catch (IOException e) {
                throw new ChannelException(e);
            }
        }
        this.options = null;
    }

    @Override
    public AioServerSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    public AioServerSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public AioServerSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @Override
    public AioServerSocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Override
    public ServerSocketChannelConfig setDefaultHandlerByteBufType(ChannelConfig.ChannelHandlerByteBufType type) {
        super.setDefaultHandlerByteBufType(type);
        return this;
    }
}

