/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.scheduler;

import com.google.common.base.Preconditions;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.scheduler.BungeeTask;

public class BungeeScheduler
implements TaskScheduler {
    private final AtomicInteger taskCounter = new AtomicInteger();
    private final TIntObjectMap<BungeeTask> tasks = TCollections.synchronizedMap(new TIntObjectHashMap());

    @Override
    public void cancel(int id) {
        BungeeTask task = this.tasks.remove(id);
        task.getFuture().cancel(false);
    }

    @Override
    public void cancel(ScheduledTask task) {
        this.cancel(task.getId());
    }

    @Override
    public int cancel(Plugin plugin) {
        HashSet<ScheduledTask> toRemove = new HashSet<ScheduledTask>();
        for (ScheduledTask scheduledTask : this.tasks.valueCollection()) {
            if (scheduledTask.getOwner() != plugin) continue;
            toRemove.add(scheduledTask);
        }
        for (ScheduledTask scheduledTask : toRemove) {
            this.cancel(scheduledTask);
        }
        return toRemove.size();
    }

    @Override
    public ScheduledTask runAsync(Plugin owner, Runnable task) {
        return this.schedule(owner, task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, TimeUnit unit) {
        return this.prepare(owner, task).setFuture(BungeeCord.getInstance().executors.schedule(task, delay, unit));
    }

    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, long period, TimeUnit unit) {
        return this.prepare(owner, task).setFuture(BungeeCord.getInstance().executors.scheduleWithFixedDelay(task, delay, period, unit));
    }

    private BungeeTask prepare(Plugin owner, Runnable task) {
        Preconditions.checkNotNull(owner, "owner");
        Preconditions.checkNotNull(task, "task");
        BungeeTask prepared = new BungeeTask(this.taskCounter.getAndIncrement(), owner, task);
        this.tasks.put(prepared.getId(), prepared);
        return prepared;
    }
}

