/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class CommandList
extends Command {
    public CommandList() {
        super("glist", "bungeecord.command.list", new String[0]);
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        for (ServerInfo server : ProxyServer.getInstance().getServers().values()) {
            Collection<ProxiedPlayer> serverPlayers = server.getPlayers();
            StringBuilder message = new StringBuilder();
            message.append((Object)ChatColor.GREEN);
            message.append("[");
            message.append(server.getName());
            message.append("] ");
            message.append((Object)ChatColor.YELLOW);
            message.append("(");
            message.append(serverPlayers.size());
            message.append("): ");
            message.append((Object)ChatColor.RESET);
            ArrayList<String> players = new ArrayList<String>();
            for (ProxiedPlayer proxiedPlayer : serverPlayers) {
                players.add(proxiedPlayer.getDisplayName());
            }
            Collections.sort(players, String.CASE_INSENSITIVE_ORDER);
            if (!players.isEmpty()) {
                for (String string : players) {
                    message.append(string).append((Object)ChatColor.RESET).append(", ");
                }
            }
            sender.sendMessage(message.substring(0, message.length() - 2));
        }
        sender.sendMessage("Total players online: " + ProxyServer.getInstance().getPlayers().size());
    }
}

