/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;
import net.minecraft.server.WorldMapBase;
import net.minecraft.server.WorldMapDecoration;
import net.minecraft.server.WorldMapHumanTracker;

public class WorldMap
extends WorldMapBase {
    public int centerX;
    public int centerZ;
    public byte map;
    public byte scale;
    public byte[] colors = new byte[16384];
    public int f;
    public List g = new ArrayList();
    private Map j = new HashMap();
    public List decorations = new ArrayList();

    public WorldMap(String string) {
        super(string);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.map = nBTTagCompound.getByte("dimension");
        this.centerX = nBTTagCompound.getInt("xCenter");
        this.centerZ = nBTTagCompound.getInt("zCenter");
        this.scale = nBTTagCompound.getByte("scale");
        if (this.scale < 0) {
            this.scale = 0;
        }
        if (this.scale > 4) {
            this.scale = (byte)4;
        }
        int n = nBTTagCompound.getShort("width");
        int n2 = nBTTagCompound.getShort("height");
        if (n == 128 && n2 == 128) {
            this.colors = nBTTagCompound.getByteArray("colors");
        } else {
            byte[] byArray = nBTTagCompound.getByteArray("colors");
            this.colors = new byte[16384];
            int n3 = (128 - n) / 2;
            int n4 = (128 - n2) / 2;
            for (int i = 0; i < n2; ++i) {
                int n5 = i + n4;
                if (n5 < 0 && n5 >= 128) continue;
                for (int j = 0; j < n; ++j) {
                    int n6 = j + n3;
                    if (n6 < 0 && n6 >= 128) continue;
                    this.colors[n6 + n5 * 128] = byArray[j + i * n];
                }
            }
        }
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setByte("dimension", this.map);
        nBTTagCompound.setInt("xCenter", this.centerX);
        nBTTagCompound.setInt("zCenter", this.centerZ);
        nBTTagCompound.setByte("scale", this.scale);
        nBTTagCompound.setShort("width", (short)128);
        nBTTagCompound.setShort("height", (short)128);
        nBTTagCompound.setByteArray("colors", this.colors);
    }

    public void a(EntityHuman entityHuman, ItemStack itemStack) {
        if (!this.j.containsKey(entityHuman)) {
            WorldMapHumanTracker worldMapHumanTracker = new WorldMapHumanTracker(this, entityHuman);
            this.j.put(entityHuman, worldMapHumanTracker);
            this.g.add(worldMapHumanTracker);
        }
        this.decorations.clear();
        for (int i = 0; i < this.g.size(); ++i) {
            WorldMapHumanTracker worldMapHumanTracker = (WorldMapHumanTracker)this.g.get(i);
            if (worldMapHumanTracker.trackee.dead || !worldMapHumanTracker.trackee.inventory.c(itemStack)) {
                this.j.remove(worldMapHumanTracker.trackee);
                this.g.remove(worldMapHumanTracker);
                continue;
            }
            float f = (float)(worldMapHumanTracker.trackee.locX - (double)this.centerX) / (float)(1 << this.scale);
            float f2 = (float)(worldMapHumanTracker.trackee.locZ - (double)this.centerZ) / (float)(1 << this.scale);
            int n = 64;
            int n2 = 64;
            if (!(f >= (float)(-n)) || !(f2 >= (float)(-n2)) || !(f <= (float)n) || !(f2 <= (float)n2)) continue;
            byte by = 0;
            byte by2 = (byte)((double)(f * 2.0f) + 0.5);
            byte by3 = (byte)((double)(f2 * 2.0f) + 0.5);
            byte by4 = (byte)((double)worldMapHumanTracker.trackee.yaw * 16.0 / 360.0);
            if (this.map < 0) {
                int n3 = this.f / 10;
                by4 = (byte)(n3 * n3 * 34187121 + n3 * 121 >> 15 & 0xF);
            }
            if (worldMapHumanTracker.trackee.dimension != this.map) continue;
            this.decorations.add(new WorldMapDecoration(this, by, by2, by3, by4));
        }
    }

    public byte[] getUpdatePacket(ItemStack itemStack, World world, EntityHuman entityHuman) {
        WorldMapHumanTracker worldMapHumanTracker = (WorldMapHumanTracker)this.j.get(entityHuman);
        if (worldMapHumanTracker == null) {
            return null;
        }
        return worldMapHumanTracker.a(itemStack);
    }

    public void flagDirty(int n, int n2, int n3) {
        super.a();
        for (int i = 0; i < this.g.size(); ++i) {
            WorldMapHumanTracker worldMapHumanTracker = (WorldMapHumanTracker)this.g.get(i);
            if (worldMapHumanTracker.b[n] < 0 || worldMapHumanTracker.b[n] > n2) {
                worldMapHumanTracker.b[n] = n2;
            }
            if (worldMapHumanTracker.c[n] >= 0 && worldMapHumanTracker.c[n] >= n3) continue;
            worldMapHumanTracker.c[n] = n3;
        }
    }
}

