/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.mc.protocol;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;

public class PacketDefinitions {
    private static final Instruction[][] opCodes = new Instruction[256][];
    private static final Instruction BYTE;
    private static final Instruction BOOLEAN;
    private static final Instruction SHORT;
    private static final Instruction INT;
    private static final Instruction FLOAT;
    private static final Instruction LONG;
    private static final Instruction DOUBLE;
    private static final Instruction SHORT_BYTE;
    private static final Instruction BYTE_INT;
    private static final Instruction INT_BYTE;
    private static final Instruction INT_3;
    private static final Instruction INT_6;
    private static final Instruction STRING;
    private static final Instruction ITEM;
    private static final Instruction SHORT_ITEM;
    private static final Instruction METADATA;
    private static final Instruction BULK_CHUNK;
    private static final Instruction UBYTE_BYTE;

    private static void crushInstructions() {
        for (int i = 0; i < opCodes.length; ++i) {
            Instruction[] instructions = opCodes[i];
            if (instructions == null) continue;
            ArrayList<Instruction> crushed = new ArrayList<Instruction>();
            int nextJumpSize = 0;
            for (Instruction child : instructions) {
                if (child instanceof JumpOpCode) {
                    nextJumpSize += ((JumpOpCode)child).len;
                    continue;
                }
                if (nextJumpSize != 0) {
                    crushed.add(new JumpOpCode(nextJumpSize));
                }
                crushed.add(child);
                nextJumpSize = 0;
            }
            if (nextJumpSize != 0) {
                crushed.add(new JumpOpCode(nextJumpSize));
            }
            PacketDefinitions.opCodes[i] = crushed.toArray(new Instruction[crushed.size()]);
        }
    }

    public static void readPacket(DataInput in) throws IOException {
        int packetId = in.readUnsignedByte();
        Instruction[] instructions = opCodes[packetId];
        if (instructions == null) {
            throw new IOException("Unknown packet id " + packetId);
        }
        for (Instruction instruction : instructions) {
            instruction.read(in);
        }
    }

    static {
        BOOLEAN = BYTE = new JumpOpCode(1);
        SHORT = new JumpOpCode(2);
        FLOAT = INT = new JumpOpCode(4);
        DOUBLE = LONG = new JumpOpCode(8);
        SHORT_BYTE = new ShortHeader(BYTE);
        BYTE_INT = new ByteHeader(INT);
        INT_BYTE = new IntHeader(BYTE);
        INT_3 = new IntHeader(new JumpOpCode(3));
        INT_6 = new IntHeader(new JumpOpCode(6));
        STRING = new ShortHeader(SHORT);
        ITEM = new Instruction(){

            void read(DataInput in) throws IOException {
                short type = in.readShort();
                if (type >= 0) {
                    this.skip(in, 3);
                    SHORT_BYTE.read(in);
                }
            }

            public String toString() {
                return "Item";
            }
        };
        SHORT_ITEM = new ShortHeader(ITEM);
        METADATA = new Instruction(){

            void read(DataInput in) throws IOException {
                int x = in.readUnsignedByte();
                while (x != 127) {
                    int type = x >> 5;
                    switch (type) {
                        case 0: {
                            BYTE.read(in);
                            break;
                        }
                        case 1: {
                            SHORT.read(in);
                            break;
                        }
                        case 2: {
                            INT.read(in);
                            break;
                        }
                        case 3: {
                            FLOAT.read(in);
                            break;
                        }
                        case 4: {
                            STRING.read(in);
                            break;
                        }
                        case 5: {
                            this.skip(in, 5);
                            break;
                        }
                        case 6: {
                            this.skip(in, 6);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown metadata type " + type);
                        }
                    }
                    x = in.readByte();
                }
            }

            public String toString() {
                return "Metadata";
            }
        };
        BULK_CHUNK = new Instruction(){

            void read(DataInput in) throws IOException {
                short count = in.readShort();
                INT_BYTE.read(in);
                this.skip(in, count * 12);
            }

            public String toString() {
                return "Bulk Chunk";
            }
        };
        UBYTE_BYTE = new Instruction(){

            void read(DataInput in) throws IOException {
                int size = in.readUnsignedByte();
                this.skip(in, size);
            }

            public String toString() {
                return "Unsigned Byte Byte";
            }
        };
        PacketDefinitions.opCodes[0] = new Instruction[]{INT};
        PacketDefinitions.opCodes[1] = new Instruction[]{INT, STRING, BYTE, BYTE, BYTE, BYTE, BYTE};
        PacketDefinitions.opCodes[2] = new Instruction[]{BYTE, STRING, STRING, INT};
        PacketDefinitions.opCodes[3] = new Instruction[]{STRING};
        PacketDefinitions.opCodes[4] = new Instruction[]{LONG};
        PacketDefinitions.opCodes[5] = new Instruction[]{INT, SHORT, ITEM};
        PacketDefinitions.opCodes[6] = new Instruction[]{INT, INT, INT};
        PacketDefinitions.opCodes[7] = new Instruction[]{INT, INT, BOOLEAN};
        PacketDefinitions.opCodes[8] = new Instruction[]{SHORT, SHORT, FLOAT};
        PacketDefinitions.opCodes[9] = new Instruction[]{INT, BYTE, BYTE, SHORT, STRING};
        PacketDefinitions.opCodes[10] = new Instruction[]{BOOLEAN};
        PacketDefinitions.opCodes[11] = new Instruction[]{DOUBLE, DOUBLE, DOUBLE, DOUBLE, BOOLEAN};
        PacketDefinitions.opCodes[12] = new Instruction[]{FLOAT, FLOAT, BOOLEAN};
        PacketDefinitions.opCodes[13] = new Instruction[]{DOUBLE, DOUBLE, DOUBLE, DOUBLE, FLOAT, FLOAT, BOOLEAN};
        PacketDefinitions.opCodes[14] = new Instruction[]{BYTE, INT, BYTE, INT, BYTE};
        PacketDefinitions.opCodes[15] = new Instruction[]{INT, BYTE, INT, BYTE, ITEM, BYTE, BYTE, BYTE};
        PacketDefinitions.opCodes[16] = new Instruction[]{SHORT};
        PacketDefinitions.opCodes[17] = new Instruction[]{INT, BYTE, INT, BYTE, INT};
        PacketDefinitions.opCodes[18] = new Instruction[]{INT, BYTE};
        PacketDefinitions.opCodes[19] = new Instruction[]{INT, BYTE};
        PacketDefinitions.opCodes[20] = new Instruction[]{INT, STRING, INT, INT, INT, BYTE, BYTE, SHORT, METADATA};
        PacketDefinitions.opCodes[21] = new Instruction[]{INT, SHORT, BYTE, SHORT, INT, INT, INT, BYTE, BYTE, BYTE};
        PacketDefinitions.opCodes[22] = new Instruction[]{INT, INT};
        PacketDefinitions.opCodes[23] = new Instruction[]{INT, BYTE, INT, INT, INT, INT_6};
        PacketDefinitions.opCodes[24] = new Instruction[]{INT, BYTE, INT, INT, INT, BYTE, BYTE, BYTE, SHORT, SHORT, SHORT, METADATA};
        PacketDefinitions.opCodes[25] = new Instruction[]{INT, STRING, INT, INT, INT, INT};
        PacketDefinitions.opCodes[26] = new Instruction[]{INT, INT, INT, INT, SHORT};
        PacketDefinitions.opCodes[27] = null;
        PacketDefinitions.opCodes[28] = new Instruction[]{INT, SHORT, SHORT, SHORT};
        PacketDefinitions.opCodes[29] = new Instruction[]{BYTE_INT};
        PacketDefinitions.opCodes[30] = new Instruction[]{INT};
        PacketDefinitions.opCodes[31] = new Instruction[]{INT, BYTE, BYTE, BYTE};
        PacketDefinitions.opCodes[32] = new Instruction[]{INT, BYTE, BYTE};
        PacketDefinitions.opCodes[33] = new Instruction[]{INT, BYTE, BYTE, BYTE, BYTE, BYTE};
        PacketDefinitions.opCodes[34] = new Instruction[]{INT, INT, INT, INT, BYTE, BYTE};
        PacketDefinitions.opCodes[35] = new Instruction[]{INT, BYTE};
        PacketDefinitions.opCodes[36] = null;
        PacketDefinitions.opCodes[37] = null;
        PacketDefinitions.opCodes[38] = new Instruction[]{INT, BYTE};
        PacketDefinitions.opCodes[39] = new Instruction[]{INT, INT};
        PacketDefinitions.opCodes[40] = new Instruction[]{INT, METADATA};
        PacketDefinitions.opCodes[41] = new Instruction[]{INT, BYTE, BYTE, SHORT};
        PacketDefinitions.opCodes[42] = new Instruction[]{INT, BYTE};
        PacketDefinitions.opCodes[43] = new Instruction[]{FLOAT, SHORT, SHORT};
        PacketDefinitions.opCodes[51] = new Instruction[]{INT, INT, BOOLEAN, SHORT, SHORT, INT_BYTE};
        PacketDefinitions.opCodes[52] = new Instruction[]{INT, INT, SHORT, INT_BYTE};
        PacketDefinitions.opCodes[53] = new Instruction[]{INT, BYTE, INT, SHORT, BYTE};
        PacketDefinitions.opCodes[54] = new Instruction[]{INT, SHORT, INT, BYTE, BYTE, SHORT};
        PacketDefinitions.opCodes[55] = new Instruction[]{INT, INT, INT, INT, BYTE};
        PacketDefinitions.opCodes[56] = new Instruction[]{BULK_CHUNK};
        PacketDefinitions.opCodes[57] = null;
        PacketDefinitions.opCodes[58] = null;
        PacketDefinitions.opCodes[59] = null;
        PacketDefinitions.opCodes[60] = new Instruction[]{DOUBLE, DOUBLE, DOUBLE, FLOAT, INT_3, FLOAT, FLOAT, FLOAT};
        PacketDefinitions.opCodes[61] = new Instruction[]{INT, INT, BYTE, INT, INT};
        PacketDefinitions.opCodes[62] = new Instruction[]{STRING, INT, INT, INT, FLOAT, BYTE};
        PacketDefinitions.opCodes[70] = new Instruction[]{BYTE, BYTE};
        PacketDefinitions.opCodes[71] = new Instruction[]{INT, BOOLEAN, INT, INT, INT};
        PacketDefinitions.opCodes[100] = new Instruction[]{BYTE, BYTE, STRING, BYTE};
        PacketDefinitions.opCodes[101] = new Instruction[]{BYTE};
        PacketDefinitions.opCodes[102] = new Instruction[]{BYTE, SHORT, BOOLEAN, SHORT, BOOLEAN, ITEM};
        PacketDefinitions.opCodes[103] = new Instruction[]{BYTE, SHORT, ITEM};
        PacketDefinitions.opCodes[104] = new Instruction[]{BYTE, SHORT_ITEM};
        PacketDefinitions.opCodes[105] = new Instruction[]{BYTE, SHORT, SHORT};
        PacketDefinitions.opCodes[106] = new Instruction[]{BYTE, SHORT, BOOLEAN};
        PacketDefinitions.opCodes[107] = new Instruction[]{SHORT, ITEM};
        PacketDefinitions.opCodes[108] = new Instruction[]{BYTE, BYTE};
        PacketDefinitions.opCodes[130] = new Instruction[]{INT, SHORT, INT, STRING, STRING, STRING, STRING};
        PacketDefinitions.opCodes[131] = new Instruction[]{SHORT, SHORT, UBYTE_BYTE};
        PacketDefinitions.opCodes[132] = new Instruction[]{INT, SHORT, INT, BYTE, SHORT_BYTE};
        PacketDefinitions.opCodes[200] = new Instruction[]{INT, BYTE};
        PacketDefinitions.opCodes[201] = new Instruction[]{STRING, BOOLEAN, SHORT};
        PacketDefinitions.opCodes[202] = new Instruction[]{BYTE, BYTE, BYTE};
        PacketDefinitions.opCodes[203] = new Instruction[]{STRING};
        PacketDefinitions.opCodes[204] = new Instruction[]{STRING, BYTE, BYTE, BYTE};
        PacketDefinitions.opCodes[205] = new Instruction[]{BYTE};
        PacketDefinitions.opCodes[250] = new Instruction[]{STRING, SHORT_BYTE};
        PacketDefinitions.opCodes[251] = null;
        PacketDefinitions.opCodes[252] = new Instruction[]{SHORT_BYTE, SHORT_BYTE};
        PacketDefinitions.opCodes[253] = new Instruction[]{STRING, SHORT_BYTE, SHORT_BYTE};
        PacketDefinitions.opCodes[254] = new Instruction[0];
        PacketDefinitions.opCodes[255] = new Instruction[]{STRING};
        PacketDefinitions.crushInstructions();
    }

    static class IntHeader
    extends Instruction {
        private final Instruction child;

        public IntHeader(Instruction child) {
            this.child = child;
        }

        void read(DataInput in) throws IOException {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.child.read(in);
            }
        }

        public String toString() {
            return "IntHeader(" + this.child + ")";
        }
    }

    static class ShortHeader
    extends Instruction {
        private final Instruction child;

        public ShortHeader(Instruction child) {
            this.child = child;
        }

        void read(DataInput in) throws IOException {
            short size = in.readShort();
            for (short s = 0; s < size; s = (short)(s + 1)) {
                this.child.read(in);
            }
        }

        public String toString() {
            return "ShortHeader(" + this.child + ")";
        }
    }

    static class ByteHeader
    extends Instruction {
        private final Instruction child;

        public ByteHeader(Instruction child) {
            this.child = child;
        }

        void read(DataInput in) throws IOException {
            byte size = in.readByte();
            for (byte b = 0; b < size; b = (byte)(b + 1)) {
                this.child.read(in);
            }
        }

        public String toString() {
            return "ByteHeader(" + this.child + ")";
        }
    }

    static class JumpOpCode
    extends Instruction {
        private final int len;

        public JumpOpCode(int len) {
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.len = len;
        }

        void read(DataInput in) throws IOException {
            this.skip(in, this.len);
        }

        public String toString() {
            return "Jump(" + this.len + ")";
        }
    }

    static abstract class Instruction {
        Instruction() {
        }

        abstract void read(DataInput var1) throws IOException;

        final void skip(DataInput in, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                in.readUnsignedByte();
            }
        }
    }
}

