/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.config;

import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public abstract class ServerInfo {
    private final String name;
    private final InetSocketAddress address;
    private final Collection<ProxiedPlayer> players = new ArrayList<ProxiedPlayer>();
    private final boolean restricted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.add(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProxiedPlayer> getPlayers() {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.players);
        }
    }

    public abstract void sendData(String var1, byte[] var2);

    public abstract void ping(Callback<ServerPing> var1);

    public boolean canAccess(ProxiedPlayer player) {
        return this.restricted && player.hasPermission("bungeecord.server." + this.name);
    }

    public String getName() {
        return this.name;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerInfo)) {
            return false;
        }
        ServerInfo other = (ServerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        InetSocketAddress this$address = this.getAddress();
        InetSocketAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Collection<ProxiedPlayer> this$players = this.getPlayers();
        Collection<ProxiedPlayer> other$players = other.getPlayers();
        if (this$players == null ? other$players != null : !((Object)this$players).equals(other$players)) {
            return false;
        }
        return this.isRestricted() == other.isRestricted();
    }

    public boolean canEqual(Object other) {
        return other instanceof ServerInfo;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        InetSocketAddress $address = this.getAddress();
        result = result * 31 + ($address == null ? 0 : ((Object)$address).hashCode());
        Collection<ProxiedPlayer> $players = this.getPlayers();
        result = result * 31 + ($players == null ? 0 : ((Object)$players).hashCode());
        result = result * 31 + (this.isRestricted() ? 1231 : 1237);
        return result;
    }

    public String toString() {
        return "ServerInfo(name=" + this.getName() + ", address=" + this.getAddress() + ", players=" + this.getPlayers() + ", restricted=" + this.isRestricted() + ")";
    }

    @ConstructorProperties(value={"name", "address", "restricted"})
    public ServerInfo(String name, InetSocketAddress address, boolean restricted) {
        this.name = name;
        this.address = address;
        this.restricted = restricted;
    }
}

