/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.stream;

import io.netty.buffer.Buf;
import io.netty.buffer.stream.Stream;
import io.netty.buffer.stream.StreamConsumer;
import io.netty.buffer.stream.StreamConsumerContext;
import io.netty.buffer.stream.StreamConsumerException;
import io.netty.buffer.stream.StreamProducer;
import io.netty.buffer.stream.StreamProducerContext;
import io.netty.buffer.stream.StreamProducerException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Random;

public abstract class AbstractStream<T extends Buf>
implements Stream<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractStream.class);
    private static final Random random = new Random();
    private static final ThreadLocal<Boolean> IN_CONSUMER = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final StreamProducerContextImpl producerCtx;
    private StreamConsumerContextImpl consumerCtx;
    private Runnable invokeStreamConsumedTask;
    int state;
    T buffer;

    private static String nextLogKey() {
        return Long.toHexString((long)random.nextInt() & 0xFFFFFFFFL);
    }

    protected AbstractStream(EventExecutor executor, StreamProducer<? super T> producer) {
        this.producerCtx = new StreamProducerContextImpl(executor, producer);
    }

    T buffer() {
        T buffer = this.buffer;
        if (buffer == null) {
            this.fail();
        }
        return buffer;
    }

    @Override
    public void accept(EventExecutor executor, StreamConsumer<? super T> consumer) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        if (consumer == null) {
            throw new NullPointerException("handler");
        }
        if (this.state != 0) {
            this.fail();
        }
        StreamConsumerContextImpl consumerCtx = new StreamConsumerContextImpl(executor, consumer);
        StreamConsumer<T> h = consumer;
        try {
            this.buffer = h.newStreamBuffer(consumerCtx);
        }
        catch (Throwable t) {
            PlatformDependent.throwException(t);
        }
        this.consumerCtx = consumerCtx;
        this.state = 1;
        this.fireStreamAccepted();
    }

    private void fireStreamAccepted() {
        EventExecutor e = this.producerCtx.executor;
        if (e.inEventLoop()) {
            this.invokeStreamAccepted();
        } else {
            e.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractStream.this.invokeStreamAccepted();
                }
            });
        }
    }

    private void invokeStreamAccepted() {
        StreamProducerContextImpl producerCtx = this.producerCtx;
        try {
            producerCtx.producer.streamAccepted(producerCtx);
        }
        catch (Throwable t) {
            this.safeAbort(producerCtx, t);
            return;
        }
        if (this.consumerCtx.nextCalled) {
            this.consumerCtx.invokeStreamConsumed();
        }
    }

    void safeAbort(StreamProducerContextImpl producerCtx, Throwable cause) {
        block2: {
            try {
                producerCtx.abort(cause);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                String key = AbstractStream.nextLogKey();
                logger.warn("[{}] Failed to auto-abort a stream.", (Object)key, (Object)t);
                logger.warn("[{}] .. when invoked with the following cause:", (Object)key, (Object)cause);
            }
        }
    }

    @Override
    public void discard() {
        StreamConsumerContextImpl consumerCtx = this.consumerCtx;
        if (consumerCtx == null) {
            this.fail();
        }
        consumerCtx.discard();
    }

    @Override
    public void reject(Throwable cause) {
        StreamConsumerContextImpl consumerCtx = this.consumerCtx;
        if (consumerCtx == null) {
            this.fail();
        }
        consumerCtx.reject(cause);
    }

    private void fail() {
        switch (this.state) {
            case 0: {
                throw new IllegalStateException("stream not accepted yet");
            }
            case 1: {
                throw new IllegalStateException("stream accepted already");
            }
            case 2: {
                throw new IllegalStateException("stream discarded already");
            }
            case 3: {
                throw new IllegalStateException("stream rejected already");
            }
            case 4: {
                throw new IllegalStateException("stream closed already");
            }
        }
        throw new Error();
    }

    private final class StreamConsumerContextImpl
    implements StreamConsumerContext<T> {
        final EventExecutor executor;
        final StreamConsumer<T> consumer;
        final boolean singleThreaded;
        boolean nextCalled;

        StreamConsumerContextImpl(EventExecutor executor, StreamConsumer<? super T> consumer) {
            if (executor == null) {
                throw new NullPointerException("executor");
            }
            if (consumer == null) {
                throw new NullPointerException("consumer");
            }
            this.executor = executor;
            this.consumer = consumer;
            this.singleThreaded = executor == ((AbstractStream)AbstractStream.this).producerCtx.executor;
        }

        @Override
        public EventExecutor executor() {
            return this.executor;
        }

        @Override
        public T buffer() {
            return AbstractStream.this.buffer();
        }

        @Override
        public void discard() {
            switch (AbstractStream.this.state) {
                case 2: {
                    return;
                }
                case 3: 
                case 4: {
                    AbstractStream.this.fail();
                }
            }
            Object buffer = AbstractStream.this.buffer;
            if (buffer != null) {
                buffer.release();
            }
            AbstractStream.this.state = 2;
            this.fireStreamDiscarded();
        }

        private void fireStreamDiscarded() {
            EventExecutor e = ((AbstractStream)AbstractStream.this).producerCtx.executor;
            if (e.inEventLoop()) {
                this.invokeStreamDiscarded();
            } else {
                e.execute(new Runnable(){

                    @Override
                    public void run() {
                        StreamConsumerContextImpl.this.invokeStreamDiscarded();
                    }
                });
            }
        }

        private void invokeStreamDiscarded() {
            StreamProducerContextImpl producerCtx = AbstractStream.this.producerCtx;
            try {
                producerCtx.producer.streamDiscarded(producerCtx);
            }
            catch (Throwable t) {
                logger.warn("StreamProducer.streamDiscarded() raised an exception.", t);
            }
        }

        @Override
        public void reject(Throwable cause) {
            Object buffer;
            if (cause == null) {
                throw new NullPointerException("cause");
            }
            if (AbstractStream.this.state != 1) {
                AbstractStream.this.fail();
            }
            if ((buffer = AbstractStream.this.buffer) != null) {
                buffer.release();
            }
            AbstractStream.this.state = 3;
            this.fireStreamRejected(cause);
        }

        private void fireStreamRejected(final Throwable cause) {
            EventExecutor e = ((AbstractStream)AbstractStream.this).producerCtx.executor;
            if (e.inEventLoop()) {
                this.invokeStreamRejected(cause);
            } else {
                e.execute(new Runnable(){

                    @Override
                    public void run() {
                        StreamConsumerContextImpl.this.invokeStreamRejected(cause);
                    }
                });
            }
        }

        private void invokeStreamRejected(Throwable cause) {
            block2: {
                StreamProducerContextImpl producerCtx = AbstractStream.this.producerCtx;
                try {
                    producerCtx.producer.streamRejected(producerCtx, cause);
                }
                catch (Throwable t) {
                    if (!logger.isWarnEnabled()) break block2;
                    String key = AbstractStream.nextLogKey();
                    logger.warn("[{}] StreamProducer.streamRejected() raised an exception.", (Object)key, (Object)t);
                    logger.warn("[{}] .. when invoked with the following cause:", (Object)key, (Object)cause);
                }
            }
        }

        @Override
        public void next() {
            if (AbstractStream.this.state != 1) {
                AbstractStream.this.fail();
            }
            if (this.singleThreaded && ((Boolean)IN_CONSUMER.get()).booleanValue()) {
                this.nextCalled = true;
            } else {
                this.fireStreamConsumed();
            }
        }

        private void fireStreamConsumed() {
            EventExecutor e = ((AbstractStream)AbstractStream.this).producerCtx.executor;
            if (e.inEventLoop()) {
                this.invokeStreamConsumed();
            } else {
                Runnable task = AbstractStream.this.invokeStreamConsumedTask;
                if (task == null) {
                    task = new Runnable(){

                        @Override
                        public void run() {
                            StreamConsumerContextImpl.this.invokeStreamConsumed();
                        }
                    };
                    AbstractStream.this.invokeStreamConsumedTask = task;
                }
                e.execute(task);
            }
        }

        private void invokeStreamConsumed() {
            StreamProducerContextImpl producerCtx = AbstractStream.this.producerCtx;
            try {
                do {
                    ((AbstractStream)AbstractStream.this).consumerCtx.nextCalled = false;
                    producerCtx.producer.streamConsumed(producerCtx);
                } while (((AbstractStream)AbstractStream.this).consumerCtx.nextCalled);
            }
            catch (Throwable t) {
                this.reject(new StreamProducerException(t));
            }
        }
    }

    private final class StreamProducerContextImpl
    implements StreamProducerContext<T> {
        final EventExecutor executor;
        final StreamProducer<T> producer;
        boolean invokedStreamOpen;
        Runnable invokeStreamUpdatedTask;

        StreamProducerContextImpl(EventExecutor executor, StreamProducer<? super T> producer) {
            if (executor == null) {
                throw new NullPointerException("executor");
            }
            if (producer == null) {
                throw new NullPointerException("producer");
            }
            this.executor = executor;
            this.producer = producer;
        }

        @Override
        public EventExecutor executor() {
            return this.executor;
        }

        @Override
        public T buffer() {
            return AbstractStream.this.buffer();
        }

        @Override
        public StreamProducerContext<T> update() {
            if (AbstractStream.this.state != 1) {
                AbstractStream.this.fail();
            }
            this.fireStreamUpdated();
            return this;
        }

        private void fireStreamUpdated() {
            EventExecutor e = ((AbstractStream)AbstractStream.this).consumerCtx.executor;
            if (e.inEventLoop()) {
                this.invokeStreamUpdated();
            } else {
                Runnable task = this.invokeStreamUpdatedTask;
                if (task == null) {
                    this.invokeStreamUpdatedTask = task = new Runnable(){

                        @Override
                        public void run() {
                            StreamProducerContextImpl.this.invokeStreamUpdated();
                        }
                    };
                }
                e.execute(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeStreamUpdated() {
            StreamConsumerContextImpl consumerCtx = AbstractStream.this.consumerCtx;
            StreamConsumer consumer = consumerCtx.consumer;
            if (consumerCtx.singleThreaded) {
                IN_CONSUMER.set(Boolean.TRUE);
            }
            try {
                if (!this.invokedStreamOpen) {
                    this.invokedStreamOpen = true;
                    try {
                        consumer.streamOpen(consumerCtx);
                    }
                    catch (Throwable t) {
                        AbstractStream.this.safeAbort(AbstractStream.this.producerCtx, new StreamConsumerException(t));
                        if (consumerCtx.singleThreaded) {
                            IN_CONSUMER.set(Boolean.FALSE);
                        }
                        return;
                    }
                }
                try {
                    consumer.streamUpdated(consumerCtx);
                }
                catch (Throwable t) {
                    AbstractStream.this.safeAbort(AbstractStream.this.producerCtx, new StreamConsumerException(t));
                }
            }
            finally {
                if (consumerCtx.singleThreaded) {
                    IN_CONSUMER.set(Boolean.FALSE);
                }
            }
        }

        @Override
        public void close() {
            if (AbstractStream.this.state == 1) {
                AbstractStream.this.state = 4;
                this.fireStreamClosed();
            }
        }

        private void fireStreamClosed() {
            EventExecutor e = ((AbstractStream)AbstractStream.this).consumerCtx.executor;
            if (e.inEventLoop()) {
                this.invokeStreamClosed();
            } else {
                e.execute(new Runnable(){

                    @Override
                    public void run() {
                        StreamProducerContextImpl.this.invokeStreamClosed();
                    }
                });
            }
        }

        private void invokeStreamClosed() {
            StreamConsumerContextImpl consumerCtx = AbstractStream.this.consumerCtx;
            try {
                consumerCtx.consumer.streamClosed(consumerCtx);
            }
            catch (Throwable t) {
                logger.warn("StreamConsumer.streamClosed() raised an exception.", t);
            }
        }

        @Override
        public void abort(Throwable cause) {
            if (cause == null) {
                throw new NullPointerException("cause");
            }
            if (AbstractStream.this.state != 1) {
                AbstractStream.this.fail();
            }
            this.fireStreamAborted(cause);
        }

        private void fireStreamAborted(final Throwable cause) {
            StreamConsumerContextImpl consumerCtx = AbstractStream.this.consumerCtx;
            EventExecutor e = consumerCtx.executor;
            if (e.inEventLoop()) {
                this.invokeStreamAborted(cause);
            } else {
                e.execute(new Runnable(){

                    @Override
                    public void run() {
                        StreamProducerContextImpl.this.invokeStreamAborted(cause);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeStreamAborted(Throwable cause) {
            StreamConsumerContextImpl consumerCtx = AbstractStream.this.consumerCtx;
            try {
                consumerCtx.consumer.streamAborted(consumerCtx, cause);
            }
            catch (Throwable t) {
                if (logger.isWarnEnabled()) {
                    String key = AbstractStream.nextLogKey();
                    logger.warn("[{}] StreamConsumer.streamAborted() raised an exception.", (Object)key, (Object)t);
                    logger.warn("[{}] .. when invoked with the following cause:", (Object)key, (Object)cause);
                }
            }
            finally {
                this.invokeStreamClosed();
            }
        }
    }
}

