/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.Map;

public abstract class HttpObjectEncoder<H extends HttpMessage>
extends MessageToByteEncoder<HttpObject> {
    private static final int ST_INIT = 0;
    private static final int ST_CONTENT_NON_CHUNK = 1;
    private static final int ST_CONTENT_CHUNK = 2;
    private int state = 0;

    @Override
    protected void encode(ChannelHandlerContext ctx, HttpObject msg, ByteBuf out) throws Exception {
        if (msg instanceof HttpMessage) {
            if (this.state != 0) {
                throw new IllegalStateException("unexpected message type: " + msg.getClass().getSimpleName());
            }
            HttpMessage m = (HttpMessage)msg;
            this.encodeInitialLine(out, m);
            HttpObjectEncoder.encodeHeaders(out, m);
            out.writeByte(13);
            out.writeByte(10);
            int n = this.state = HttpHeaders.isTransferEncodingChunked(m) ? 2 : 1;
        }
        if (msg instanceof HttpContent) {
            if (this.state == 0) {
                throw new IllegalStateException("unexpected message type: " + msg.getClass().getSimpleName());
            }
            HttpContent chunk = (HttpContent)msg;
            ByteBuf content = chunk.data();
            int contentLength = content.readableBytes();
            if (this.state == 1) {
                if (contentLength > 0) {
                    out.writeBytes(content, content.readerIndex(), content.readableBytes());
                }
                if (chunk instanceof LastHttpContent) {
                    this.state = 0;
                }
            } else if (this.state == 2) {
                if (contentLength > 0) {
                    out.writeBytes(Unpooled.copiedBuffer(Integer.toHexString(contentLength), CharsetUtil.US_ASCII));
                    out.writeByte(13);
                    out.writeByte(10);
                    out.writeBytes(content, content.readerIndex(), contentLength);
                    out.writeByte(13);
                    out.writeByte(10);
                }
                if (chunk instanceof LastHttpContent) {
                    out.writeByte(48);
                    out.writeByte(13);
                    out.writeByte(10);
                    HttpObjectEncoder.encodeTrailingHeaders(out, (LastHttpContent)chunk);
                    out.writeByte(13);
                    out.writeByte(10);
                    this.state = 0;
                }
            } else {
                throw new Error();
            }
        }
    }

    private static void encodeHeaders(ByteBuf buf, HttpMessage message) {
        for (Map.Entry h : message.headers()) {
            HttpObjectEncoder.encodeHeader(buf, (String)h.getKey(), (String)h.getValue());
        }
    }

    private static void encodeTrailingHeaders(ByteBuf buf, LastHttpContent trailer) {
        for (Map.Entry h : trailer.trailingHeaders()) {
            HttpObjectEncoder.encodeHeader(buf, (String)h.getKey(), (String)h.getValue());
        }
    }

    private static void encodeHeader(ByteBuf buf, String header, String value) {
        buf.writeBytes(header.getBytes(CharsetUtil.US_ASCII));
        buf.writeByte(58);
        buf.writeByte(32);
        buf.writeBytes(value.getBytes(CharsetUtil.US_ASCII));
        buf.writeByte(13);
        buf.writeByte(10);
    }

    protected abstract void encodeInitialLine(ByteBuf var1, H var2) throws Exception;
}

