/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.InitialHandler;
import net.md_5.bungee.Logger;
import net.md_5.bungee.api.config.ListenerInfo;

public class ListenThread
extends Thread {
    public final ServerSocket socket;
    private final ListenerInfo info;

    public ListenThread(ListenerInfo info) throws IOException {
        super("Listen Thread - " + info);
        this.info = info;
        this.socket = new ServerSocket();
        this.socket.bind(info.getHost());
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Socket client = this.socket.accept();
                BungeeCord.getInstance().setSocketOptions(client);
                Logger.$().info(client.getInetAddress() + " has connected");
                InitialHandler handler = new InitialHandler(client, this.info);
                BungeeCord.getInstance().threadPool.submit(handler);
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

