/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.GenericConnection;
import net.md_5.bungee.KickException;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet0KeepAlive;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketStream;

public final class UserConnection
extends GenericConnection
implements ProxiedPlayer {
    public final Packet2Handshake handshake;
    final Packet1Login forgeLogin;
    final List<PacketFAPluginMessage> loginMessages;
    public Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();
    private final PendingConnection pendingConnection;
    private ServerConnection server;
    private UpstreamBridge upBridge;
    private DownstreamBridge downBridge;
    private int clientEntityId;
    private int serverEntityId;
    private volatile boolean reconnecting;
    private int trackingPingId;
    private long pingTime;
    private int ping = 1000;
    private final Collection<String> groups = new HashSet<String>();
    private final Map<String, Boolean> permissions = new HashMap<String, Boolean>();
    private final Object permMutex = new Object();
    private ServerInfo nextServer;
    private volatile boolean clientConnected = true;

    public UserConnection(Socket socket, PendingConnection pendingConnection, PacketStream stream, Packet2Handshake handshake, Packet1Login forgeLogin, List<PacketFAPluginMessage> loginMessages) {
        super(socket, stream);
        this.handshake = handshake;
        this.pendingConnection = pendingConnection;
        this.forgeLogin = forgeLogin;
        this.loginMessages = loginMessages;
        this.displayName = this.name = handshake.username.substring(0, Math.min(handshake.username.length(), 16));
        Collection<String> g = ProxyServer.getInstance().getConfigurationAdapter().getGroups(this.name);
        for (String s : g) {
            this.addGroups(s);
        }
    }

    @Override
    public void setDisplayName(String name) {
        ProxyServer.getInstance().getTabListHandler().onDisconnect(this);
        this.displayName = name;
        ProxyServer.getInstance().getTabListHandler().onConnect(this);
    }

    @Override
    public void connect(ServerInfo target) {
        this.nextServer = target;
    }

    public void connect(ServerInfo target, boolean force) {
        this.nextServer = null;
        if (this.server == null) {
            BungeeCord.getInstance().connections.put(this.name, this);
            ProxyServer.getInstance().getTabListHandler().onConnect(this);
        }
        ServerConnectEvent event = new ServerConnectEvent(this, target);
        BungeeCord.getInstance().getPluginManager().callEvent(event);
        target = event.getTarget();
        ProxyServer.getInstance().getTabListHandler().onServerChange(this);
        try {
            this.reconnecting = true;
            if (this.server != null) {
                this.stream.write(new Packet9Respawn(1, 0, 0, 256, "DEFAULT"));
                this.stream.write(new Packet9Respawn(-1, 0, 0, 256, "DEFAULT"));
            }
            ServerConnection newServer = ServerConnector.connect(this, target, true);
            if (this.server == null) {
                this.clientEntityId = newServer.loginPacket.entityId;
                this.serverEntityId = newServer.loginPacket.entityId;
                Packet1Login s = newServer.loginPacket;
                Packet1Login login = new Packet1Login(s.entityId, s.levelType, s.gameMode, (byte)s.dimension, s.difficulty, s.unused, (byte)this.pendingConnection.getListener().getTabListSize());
                this.stream.write(login);
                this.stream.write(BungeeCord.getInstance().registerChannels());
                this.upBridge = new UpstreamBridge();
                this.upBridge.start();
            } else {
                try {
                    this.downBridge.interrupt();
                    this.downBridge.join();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.server.disconnect("Quitting");
                this.server.getInfo().removePlayer(this);
                Packet1Login login = newServer.loginPacket;
                this.serverEntityId = login.entityId;
                this.stream.write(new Packet9Respawn(login.dimension, login.difficulty, login.gameMode, 256, login.levelType));
            }
            this.reconnecting = false;
            target.addPlayer(this);
            this.server = newServer;
            this.downBridge = new DownstreamBridge();
            this.downBridge.start();
        }
        catch (KickException ex) {
            this.disconnect(ex.getMessage());
        }
        catch (Exception ex) {
            this.disconnect("Could not connect to server - " + Util.exception(ex));
        }
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (this.clientConnected) {
            PlayerDisconnectEvent event = new PlayerDisconnectEvent(this);
            ProxyServer.getInstance().getPluginManager().callEvent(event);
            ProxyServer.getInstance().getTabListHandler().onDisconnect(this);
            ProxyServer.getInstance().getPlayers().remove(this);
            super.disconnect(reason);
            if (this.server != null) {
                this.server.getInfo().removePlayer(this);
                this.server.disconnect("Quitting");
                ProxyServer.getInstance().getReconnectHandler().setServer(this);
            }
            this.clientConnected = false;
        }
    }

    @Override
    public void sendMessage(String message) {
        this.packetQueue.add(new Packet3Chat(message));
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.server.packetQueue.add(new PacketFAPluginMessage(channel, data));
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getGroups() {
        Object object = this.permMutex;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroups(String ... groups) {
        Object object = this.permMutex;
        synchronized (object) {
            for (String group : groups) {
                this.groups.add(group);
                for (String permission : ProxyServer.getInstance().getConfigurationAdapter().getPermissions(group)) {
                    this.setPermission(permission, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroups(String ... groups) {
        Object object = this.permMutex;
        synchronized (object) {
            for (String group : groups) {
                this.groups.remove(group);
                for (String permission : ProxyServer.getInstance().getConfigurationAdapter().getPermissions(group)) {
                    this.setPermission(permission, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermission(String permission) {
        Object object = this.permMutex;
        synchronized (object) {
            Boolean val = this.permissions.get(permission);
            return val == null ? false : val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermission(String permission, boolean value) {
        Object object = this.permMutex;
        synchronized (object) {
            this.permissions.put(permission, value);
        }
    }

    @Override
    public PendingConnection getPendingConnection() {
        return this.pendingConnection;
    }

    @Override
    public ServerConnection getServer() {
        return this.server;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    static /* synthetic */ boolean access$600(UserConnection x0) {
        return x0.reconnecting;
    }

    static /* synthetic */ int access$002(UserConnection x0, int x1) {
        x0.trackingPingId = x1;
        return x0.trackingPingId;
    }

    static /* synthetic */ long access$102(UserConnection x0, long x1) {
        x0.pingTime = x1;
        return x0.pingTime;
    }

    static /* synthetic */ ServerInfo access$700(UserConnection x0) {
        return x0.nextServer;
    }

    private class DownstreamBridge
    extends Thread {
        public DownstreamBridge() {
            super("Downstream Bridge - " + UserConnection.this.name);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 10[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class UpstreamBridge
    extends Thread {
        public UpstreamBridge() {
            super("Upstream Bridge - " + UserConnection.this.name);
        }

        @Override
        public void run() {
            block10: while (!UserConnection.this.socket.isClosed()) {
                try {
                    byte[] packet = UserConnection.this.stream.readPacket();
                    boolean sendPacket = true;
                    int id = Util.getId(packet);
                    switch (id) {
                        case 0: {
                            if (UserConnection.this.trackingPingId != new Packet0KeepAlive((byte[])packet).id) break;
                            int newPing = (int)(System.currentTimeMillis() - UserConnection.this.pingTime);
                            ProxyServer.getInstance().getTabListHandler().onPingChange(UserConnection.this, newPing);
                            UserConnection.this.ping = newPing;
                            break;
                        }
                        case 3: {
                            Packet3Chat chat = new Packet3Chat(packet);
                            if (chat.message.startsWith("/")) {
                                sendPacket = !ProxyServer.getInstance().getPluginManager().dispatchCommand(UserConnection.this, chat.message.substring(1));
                                break;
                            }
                            ChatEvent chatEvent = new ChatEvent(UserConnection.this, UserConnection.this.server, chat.message);
                            ProxyServer.getInstance().getPluginManager().callEvent(chatEvent);
                            sendPacket = !chatEvent.isCancelled();
                            break;
                        }
                        case 250: {
                            PacketFAPluginMessage message = new PacketFAPluginMessage(packet);
                            if (message.tag.equals("BungeeCord")) continue block10;
                            PluginMessageEvent event = new PluginMessageEvent(UserConnection.this, UserConnection.this.server, message.tag, message.data);
                            ProxyServer.getInstance().getPluginManager().callEvent(event);
                            if (!event.isCancelled()) break;
                            continue block10;
                        }
                    }
                    while (!((UserConnection)UserConnection.this).server.packetQueue.isEmpty()) {
                        DefinedPacket p = ((UserConnection)UserConnection.this).server.packetQueue.poll();
                        if (p == null) continue;
                        ((UserConnection)UserConnection.this).server.stream.write(p);
                    }
                    EntityMap.rewrite(packet, UserConnection.this.clientEntityId, UserConnection.this.serverEntityId);
                    if (sendPacket && !((UserConnection)UserConnection.this).server.socket.isClosed()) {
                        ((UserConnection)UserConnection.this).server.stream.write(packet);
                    }
                    try {
                        Thread.sleep(BungeeCord.getInstance().config.getSleepTime());
                    }
                    catch (InterruptedException ex) {
                    }
                }
                catch (IOException ex) {
                    UserConnection.this.disconnect("Reached end of stream");
                }
                catch (Exception ex) {
                    UserConnection.this.disconnect(Util.exception(ex));
                }
            }
        }
    }
}

