/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.GenericConnection;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketStream;

public class ServerConnection
extends GenericConnection
implements Server {
    private final ServerInfo info;
    public final Packet1Login loginPacket;
    public Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();

    public ServerConnection(Socket socket, ServerInfo info, PacketStream stream, Packet1Login loginPacket) {
        super(socket, stream);
        this.info = info;
        this.loginPacket = loginPacket;
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.packetQueue.add(new PacketFAPluginMessage(channel, data));
    }

    @Override
    public void ping(Callback<ServerPing> callback) {
        this.getInfo().ping(callback);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getInfo().getAddress();
    }

    @Override
    public ServerInfo getInfo() {
        return this.info;
    }
}

