/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;

public class MinecraftDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private Protocol protocol;
    private final boolean server;
    private int protocolVersion;
    private boolean copyBuffer;

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion) {
        this(protocol, server, protocolVersion, MinecraftDecoder.shouldCopyBuffer(protocol, protocolVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            return;
        }
        Protocol.DirectionData prot = this.server ? this.protocol.TO_SERVER : this.protocol.TO_CLIENT;
        ByteBuf slice = this.copyBuffer ? in.copy() : in.retainedSlice();
        try {
            int packetId = DefinedPacket.readVarInt(in);
            DefinedPacket packet = prot.createPacket(packetId, this.protocolVersion);
            if (packet != null) {
                packet.read(in, this.protocol, prot.getDirection(), this.protocolVersion);
                if (in.isReadable()) {
                    throw new BadPacketException("Packet " + (Object)((Object)this.protocol) + ":" + (Object)((Object)prot.getDirection()) + "/" + packetId + " (" + packet.getClass().getSimpleName() + ") larger than expected, extra bytes: " + in.readableBytes());
                }
            } else {
                in.skipBytes(in.readableBytes());
            }
            out.add(new PacketWrapper(packet, slice, this.protocol));
            slice = null;
        }
        finally {
            if (slice != null) {
                slice.release();
            }
        }
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
        this.copyBuffer = MinecraftDecoder.shouldCopyBuffer(protocol, this.protocolVersion);
    }

    private static boolean shouldCopyBuffer(Protocol protocol, int protocolVersion) {
        return protocol == Protocol.GAME && protocolVersion < 764;
    }

    @Generated
    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion, boolean copyBuffer) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
        this.copyBuffer = copyBuffer;
    }

    @Generated
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }
}

