/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.limit;

import lombok.Generated;
import net.md_5.bungee.nbt.exception.NBTLimitException;

public class NBTLimiter {
    private static final int MAX_STACK_DEPTH = 512;
    private final long maxBytes;
    private final int maxDepth;
    private long usedBytes;
    private int depth;

    public static NBTLimiter unlimitedSize() {
        return new NBTLimiter(Long.MAX_VALUE, 512);
    }

    public NBTLimiter(long maxBytes) {
        this(maxBytes, 512);
    }

    public void countBytes(long amount) {
        if (amount < 0L) {
            throw new NBTLimitException("NBT limiter tried to count negative byte amount");
        }
        this.usedBytes = Math.addExact(this.usedBytes, amount);
        if (this.usedBytes > this.maxBytes) {
            throw new NBTLimitException("NBT tag is to big, bytes > " + this.maxBytes);
        }
    }

    public void countBytes(long amount, long factor) {
        if (amount < 0L || factor < 0L) {
            throw new NBTLimitException("NBT limiter tried to count negative byte amount");
        }
        this.countBytes(Math.multiplyExact(amount, factor));
    }

    public void push() {
        this.depth = Math.addExact(this.depth, 1);
        if (this.depth > this.maxDepth) {
            throw new NBTLimitException("NBT tag is to complex, depth > " + this.maxDepth);
        }
    }

    public void pop() {
        if (--this.depth < 0) {
            throw new NBTLimitException("NBT limiter tried to pop depth 0");
        }
    }

    @Generated
    public NBTLimiter(long maxBytes, int maxDepth) {
        this.maxBytes = maxBytes;
        this.maxDepth = maxDepth;
    }
}

