/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class ByteArrayTag
implements TypedTag {
    private byte[] value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(24L);
        int length = input.readInt();
        limiter.countBytes(length, 1L);
        this.value = new byte[length];
        input.readFully(this.value);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(this.value, "byte array value cannot be null");
        output.writeInt(this.value.length);
        output.write(this.value);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Generated
    public byte[] getValue() {
        return this.value;
    }

    @Generated
    public void setValue(byte[] value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteArrayTag)) {
            return false;
        }
        ByteArrayTag other = (ByteArrayTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ByteArrayTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    @Generated
    public String toString() {
        return "ByteArrayTag(value=" + Arrays.toString(this.getValue()) + ")";
    }

    @Generated
    public ByteArrayTag() {
    }

    @Generated
    public ByteArrayTag(byte[] value) {
        this.value = value;
    }
}

