/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.log;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.md_5.bungee.log.ColouredWriter;
import net.md_5.bungee.log.ConciseFormatter;
import net.md_5.bungee.log.LogDispatcher;

public class BungeeLogger
extends Logger {
    private final LogDispatcher dispatcher = new LogDispatcher(this);

    public BungeeLogger(String loggerName, String filePattern, ConsoleReader reader) {
        super(loggerName, null);
        this.setLevel(Level.ALL);
        this.setUseParentHandlers(false);
        try {
            FileHandler fileHandler = new FileHandler(filePattern, 0x1000000, 8, true);
            fileHandler.setLevel(Level.parse(System.getProperty("net.md_5.bungee.file-log-level", "INFO")));
            fileHandler.setFormatter(new ConciseFormatter(false));
            this.addHandler(fileHandler);
            ColouredWriter consoleHandler = new ColouredWriter(reader);
            consoleHandler.setLevel(Level.parse(System.getProperty("net.md_5.bungee.console-log-level", "INFO")));
            consoleHandler.setFormatter(new ConciseFormatter(true));
            this.addHandler(consoleHandler);
        }
        catch (IOException ex) {
            System.err.println("Could not register logger!");
            ex.printStackTrace();
        }
        this.dispatcher.start();
    }

    @Override
    public void log(LogRecord record) {
        this.dispatcher.queue(record);
    }

    void doLog(LogRecord record) {
        super.log(record);
    }
}

