/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.util;

import lombok.Generated;

public class PacketLimiter {
    private final int limit;
    private final int dataLimit;
    private int counter;
    private int dataCounter;
    private long nextSecond;

    public boolean incrementAndCheck(int size) {
        ++this.counter;
        this.dataCounter += size;
        if (this.limit > 0 && this.counter > this.limit || this.dataLimit > 0 && this.dataCounter > this.dataLimit) {
            long now = System.currentTimeMillis();
            if (this.nextSecond > now) {
                return false;
            }
            this.nextSecond = now + 1000L;
            this.counter = 0;
            this.dataCounter = 0;
        }
        return true;
    }

    @Generated
    public PacketLimiter(int limit, int dataLimit) {
        this.limit = limit;
        this.dataLimit = dataLimit;
    }

    @Generated
    public int getCounter() {
        return this.counter;
    }

    @Generated
    public int getDataCounter() {
        return this.dataCounter;
    }
}

