/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog.input;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.dialog.input.DialogInput;

public class NumberRangeInput
extends DialogInput {
    private Integer width;
    @NonNull
    private BaseComponent label;
    private String labelFormat;
    private float start;
    private float end;
    private Float step;
    private Float initial;

    public NumberRangeInput(@NonNull String key, @NonNull BaseComponent label, float start, float end) {
        this(key, null, label, "options.generic_value", start, end, null, null);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
    }

    public NumberRangeInput(@NonNull String key, @NonNull BaseComponent label, float start, float end, Float step) {
        this(key, null, label, "options.generic_value", start, end, step, null);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
    }

    public NumberRangeInput(@NonNull String key, @NonNull BaseComponent label, float start, float end, Float step, Float initial) {
        this(key, null, label, "options.generic_value", start, end, step, initial);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
    }

    public NumberRangeInput(@NonNull String key, Integer width, @NonNull BaseComponent label, String labelFormat, float start, float end, Float step, Float initial) {
        super("minecraft:number_range", key);
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.width(width);
        this.label = label;
        this.labelFormat = labelFormat;
        this.start = start;
        this.end = end;
        this.step(step);
        this.initial(initial);
    }

    public NumberRangeInput width(Integer width) {
        Preconditions.checkArgument(width == null || width >= 1 && width <= 1024, "with must be between 1 and 1024");
        this.width = width;
        return this;
    }

    public NumberRangeInput step(Float step) {
        Preconditions.checkArgument(step == null || step.floatValue() > 0.0f, "step must be null or greater than zero");
        this.step = step;
        return this;
    }

    public NumberRangeInput initial(Float initial) {
        float min2 = Math.min(this.start, this.end);
        float max = Math.max(this.start, this.end);
        Preconditions.checkArgument(initial == null || initial.floatValue() >= min2 && initial.floatValue() <= max, "initial must be null or between start and end");
        this.initial = initial;
        return this;
    }

    @Generated
    public Integer width() {
        return this.width;
    }

    @NonNull
    @Generated
    public BaseComponent label() {
        return this.label;
    }

    @Generated
    public String labelFormat() {
        return this.labelFormat;
    }

    @Generated
    public float start() {
        return this.start;
    }

    @Generated
    public float end() {
        return this.end;
    }

    @Generated
    public Float step() {
        return this.step;
    }

    @Generated
    public Float initial() {
        return this.initial;
    }

    @Generated
    public NumberRangeInput label(@NonNull BaseComponent label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    @Generated
    public NumberRangeInput labelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
        return this;
    }

    @Generated
    public NumberRangeInput start(float start) {
        this.start = start;
        return this;
    }

    @Generated
    public NumberRangeInput end(float end) {
        this.end = end;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "NumberRangeInput(super=" + super.toString() + ", width=" + this.width() + ", label=" + this.label() + ", labelFormat=" + this.labelFormat() + ", start=" + this.start() + ", end=" + this.end() + ", step=" + this.step() + ", initial=" + this.initial() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumberRangeInput)) {
            return false;
        }
        NumberRangeInput other = (NumberRangeInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Float.compare(this.start(), other.start()) != 0) {
            return false;
        }
        if (Float.compare(this.end(), other.end()) != 0) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$step = this.step();
        Float other$step = other.step();
        if (this$step == null ? other$step != null : !((Object)this$step).equals(other$step)) {
            return false;
        }
        Float this$initial = this.initial();
        Float other$initial = other.initial();
        if (this$initial == null ? other$initial != null : !((Object)this$initial).equals(other$initial)) {
            return false;
        }
        BaseComponent this$label = this.label();
        BaseComponent other$label = other.label();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        String this$labelFormat = this.labelFormat();
        String other$labelFormat = other.labelFormat();
        return !(this$labelFormat == null ? other$labelFormat != null : !this$labelFormat.equals(other$labelFormat));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NumberRangeInput;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Float.floatToIntBits(this.start());
        result = result * 59 + Float.floatToIntBits(this.end());
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $step = this.step();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        Float $initial = this.initial();
        result = result * 59 + ($initial == null ? 43 : ((Object)$initial).hashCode());
        BaseComponent $label = this.label();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        String $labelFormat = this.labelFormat();
        result = result * 59 + ($labelFormat == null ? 43 : $labelFormat.hashCode());
        return result;
    }
}

