/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog.action;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

public class DialogAction {
    @NonNull
    private BaseComponent label;
    private BaseComponent tooltip;
    private Integer width;

    public DialogAction(@NonNull BaseComponent label, BaseComponent tooltip, Integer width) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        this.tooltip = tooltip;
        this.setWidth(width);
    }

    public DialogAction(@NonNull BaseComponent label) {
        this(label, null, null);
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
    }

    public void setWidth(Integer width) {
        Preconditions.checkArgument(width == null || width >= 1 && width <= 1024, "width must be between 1 and 1024");
        this.width = width;
    }

    @NonNull
    @Generated
    public BaseComponent label() {
        return this.label;
    }

    @Generated
    public BaseComponent tooltip() {
        return this.tooltip;
    }

    @Generated
    public Integer width() {
        return this.width;
    }

    @Generated
    public DialogAction label(@NonNull BaseComponent label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    @Generated
    public DialogAction tooltip(BaseComponent tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    @Generated
    public DialogAction width(Integer width) {
        this.width = width;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogAction)) {
            return false;
        }
        DialogAction other = (DialogAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        BaseComponent this$label = this.label();
        BaseComponent other$label = other.label();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        BaseComponent this$tooltip = this.tooltip();
        BaseComponent other$tooltip = other.tooltip();
        return !(this$tooltip == null ? other$tooltip != null : !((Object)this$tooltip).equals(other$tooltip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DialogAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        BaseComponent $label = this.label();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        BaseComponent $tooltip = this.tooltip();
        result = result * 59 + ($tooltip == null ? 43 : ((Object)$tooltip).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DialogAction(label=" + this.label() + ", tooltip=" + this.tooltip() + ", width=" + this.width() + ")";
    }
}

