/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog.action;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

public class DialogAction {
    @NonNull
    private BaseComponent label;
    private BaseComponent tooltip;
    private Integer width;

    public DialogAction(@NonNull BaseComponent label, BaseComponent tooltip, Integer width) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        this.tooltip = tooltip;
        this.setWidth(width);
    }

    public DialogAction(BaseComponent label) {
        this(label, null, null);
    }

    public void setWidth(Integer width) {
        Preconditions.checkArgument(width == null || width >= 1 && width <= 1024, "width must be between 1 and 1024");
        this.width = width;
    }

    @NonNull
    @Generated
    public BaseComponent getLabel() {
        return this.label;
    }

    @Generated
    public BaseComponent getTooltip() {
        return this.tooltip;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @Generated
    public void setLabel(@NonNull BaseComponent label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
    }

    @Generated
    public void setTooltip(BaseComponent tooltip) {
        this.tooltip = tooltip;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogAction)) {
            return false;
        }
        DialogAction other = (DialogAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        BaseComponent this$label = this.getLabel();
        BaseComponent other$label = other.getLabel();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        BaseComponent this$tooltip = this.getTooltip();
        BaseComponent other$tooltip = other.getTooltip();
        return !(this$tooltip == null ? other$tooltip != null : !((Object)this$tooltip).equals(other$tooltip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DialogAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        BaseComponent $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        BaseComponent $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : ((Object)$tooltip).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DialogAction(label=" + this.getLabel() + ", tooltip=" + this.getTooltip() + ", width=" + this.getWidth() + ")";
    }
}

