/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Either;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Team
extends DefinedPacket {
    private String name;
    private byte mode;
    private Either<String, BaseComponent> displayName;
    private Either<String, BaseComponent> prefix;
    private Either<String, BaseComponent> suffix;
    private NameTagVisibility nameTagVisibility;
    private CollisionRule collisionRule;
    private int color;
    private byte friendlyFire;
    private String[] players;

    public Team(String name) {
        this.name = name;
        this.mode = 1;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.name = Team.readString(buf);
        this.mode = buf.readByte();
        if (this.mode == 0 || this.mode == 2) {
            if (protocolVersion < 393) {
                this.displayName = Team.readEitherBaseComponent(buf, protocolVersion, true);
                this.prefix = Team.readEitherBaseComponent(buf, protocolVersion, true);
                this.suffix = Team.readEitherBaseComponent(buf, protocolVersion, true);
            } else {
                this.displayName = Team.readEitherBaseComponent(buf, protocolVersion, false);
            }
            this.friendlyFire = buf.readByte();
            if (protocolVersion >= 1073742066) {
                this.nameTagVisibility = NameTagVisibility.BY_ID[Team.readVarInt(buf)];
                this.collisionRule = CollisionRule.BY_ID[Team.readVarInt(buf)];
            } else {
                this.nameTagVisibility = (NameTagVisibility)((Object)Team.readStringMapKey(buf, NameTagVisibility.BY_NAME));
                if (protocolVersion >= 107) {
                    this.collisionRule = (CollisionRule)((Object)Team.readStringMapKey(buf, CollisionRule.BY_NAME));
                }
            }
            int n = this.color = protocolVersion >= 393 ? Team.readVarInt(buf) : (int)buf.readByte();
            if (protocolVersion >= 393) {
                this.prefix = Team.readEitherBaseComponent(buf, protocolVersion, false);
                this.suffix = Team.readEitherBaseComponent(buf, protocolVersion, false);
            }
        }
        if (this.mode == 0 || this.mode == 3 || this.mode == 4) {
            int len = Team.readVarInt(buf);
            this.players = new String[len];
            for (int i = 0; i < len; ++i) {
                this.players[i] = Team.readString(buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        Team.writeString(this.name, buf);
        buf.writeByte(this.mode);
        if (this.mode == 0 || this.mode == 2) {
            Team.writeEitherBaseComponent(this.displayName, buf, protocolVersion);
            if (protocolVersion < 393) {
                Team.writeEitherBaseComponent(this.prefix, buf, protocolVersion);
                Team.writeEitherBaseComponent(this.suffix, buf, protocolVersion);
            }
            buf.writeByte(this.friendlyFire);
            if (protocolVersion >= 1073742066) {
                Team.writeVarInt(this.nameTagVisibility.ordinal(), buf);
                Team.writeVarInt(this.collisionRule.ordinal(), buf);
            } else {
                Team.writeString(this.nameTagVisibility.getKey(), buf);
                if (protocolVersion >= 107) {
                    Team.writeString(this.collisionRule.getKey(), buf);
                }
            }
            if (protocolVersion >= 393) {
                Team.writeVarInt(this.color, buf);
                Team.writeEitherBaseComponent(this.prefix, buf, protocolVersion);
                Team.writeEitherBaseComponent(this.suffix, buf, protocolVersion);
            } else {
                buf.writeByte(this.color);
            }
        }
        if (this.mode == 0 || this.mode == 3 || this.mode == 4) {
            Team.writeVarInt(this.players.length, buf);
            for (String player : this.players) {
                Team.writeString(player, buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public byte getMode() {
        return this.mode;
    }

    @Generated
    public Either<String, BaseComponent> getDisplayName() {
        return this.displayName;
    }

    @Generated
    public Either<String, BaseComponent> getPrefix() {
        return this.prefix;
    }

    @Generated
    public Either<String, BaseComponent> getSuffix() {
        return this.suffix;
    }

    @Generated
    public NameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Generated
    public CollisionRule getCollisionRule() {
        return this.collisionRule;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public byte getFriendlyFire() {
        return this.friendlyFire;
    }

    @Generated
    public String[] getPlayers() {
        return this.players;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Generated
    public void setDisplayName(Either<String, BaseComponent> displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setPrefix(Either<String, BaseComponent> prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setSuffix(Either<String, BaseComponent> suffix) {
        this.suffix = suffix;
    }

    @Generated
    public void setNameTagVisibility(NameTagVisibility nameTagVisibility) {
        this.nameTagVisibility = nameTagVisibility;
    }

    @Generated
    public void setCollisionRule(CollisionRule collisionRule) {
        this.collisionRule = collisionRule;
    }

    @Generated
    public void setColor(int color) {
        this.color = color;
    }

    @Generated
    public void setFriendlyFire(byte friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    @Generated
    public void setPlayers(String[] players) {
        this.players = players;
    }

    @Override
    @Generated
    public String toString() {
        return "Team(name=" + this.getName() + ", mode=" + this.getMode() + ", displayName=" + this.getDisplayName() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", nameTagVisibility=" + (Object)((Object)this.getNameTagVisibility()) + ", collisionRule=" + (Object)((Object)this.getCollisionRule()) + ", color=" + this.getColor() + ", friendlyFire=" + this.getFriendlyFire() + ", players=" + Arrays.deepToString(this.getPlayers()) + ")";
    }

    @Generated
    public Team() {
    }

    @Generated
    public Team(String name, byte mode, Either<String, BaseComponent> displayName, Either<String, BaseComponent> prefix, Either<String, BaseComponent> suffix, NameTagVisibility nameTagVisibility, CollisionRule collisionRule, int color, byte friendlyFire, String[] players) {
        this.name = name;
        this.mode = mode;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.nameTagVisibility = nameTagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.friendlyFire = friendlyFire;
        this.players = players;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Team)) {
            return false;
        }
        Team other = (Team)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        if (this.getFriendlyFire() != other.getFriendlyFire()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Either<String, BaseComponent> this$displayName = this.getDisplayName();
        Either<String, BaseComponent> other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName)) {
            return false;
        }
        Either<String, BaseComponent> this$prefix = this.getPrefix();
        Either<String, BaseComponent> other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
            return false;
        }
        Either<String, BaseComponent> this$suffix = this.getSuffix();
        Either<String, BaseComponent> other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !((Object)this$suffix).equals(other$suffix)) {
            return false;
        }
        NameTagVisibility this$nameTagVisibility = this.getNameTagVisibility();
        NameTagVisibility other$nameTagVisibility = other.getNameTagVisibility();
        if (this$nameTagVisibility == null ? other$nameTagVisibility != null : !((Object)((Object)this$nameTagVisibility)).equals((Object)other$nameTagVisibility)) {
            return false;
        }
        CollisionRule this$collisionRule = this.getCollisionRule();
        CollisionRule other$collisionRule = other.getCollisionRule();
        if (this$collisionRule == null ? other$collisionRule != null : !((Object)((Object)this$collisionRule)).equals((Object)other$collisionRule)) {
            return false;
        }
        return Arrays.deepEquals(this.getPlayers(), other.getPlayers());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Team;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMode();
        result = result * 59 + this.getColor();
        result = result * 59 + this.getFriendlyFire();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Either<String, BaseComponent> $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
        Either<String, BaseComponent> $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
        Either<String, BaseComponent> $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : ((Object)$suffix).hashCode());
        NameTagVisibility $nameTagVisibility = this.getNameTagVisibility();
        result = result * 59 + ($nameTagVisibility == null ? 43 : ((Object)((Object)$nameTagVisibility)).hashCode());
        CollisionRule $collisionRule = this.getCollisionRule();
        result = result * 59 + ($collisionRule == null ? 43 : ((Object)((Object)$collisionRule)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPlayers());
        return result;
    }

    public static enum NameTagVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam"),
        UNKNOWN("");

        private final String key;
        private static final Map<String, NameTagVisibility> BY_NAME;
        private static final NameTagVisibility[] BY_ID;

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        private NameTagVisibility(String key) {
            this.key = key;
        }

        static {
            NameTagVisibility[] values = NameTagVisibility.values();
            ImmutableMap.Builder<String, NameTagVisibility> builder = ImmutableMap.builderWithExpectedSize(values.length);
            for (NameTagVisibility e : values) {
                builder.put(e.key, e);
            }
            BY_NAME = builder.build();
            BY_ID = Arrays.copyOf(values, values.length - 1);
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        private final String key;
        private static final Map<String, CollisionRule> BY_NAME;
        private static final CollisionRule[] BY_ID;

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        private CollisionRule(String key) {
            this.key = key;
        }

        static {
            BY_ID = CollisionRule.values();
            CollisionRule[] values = BY_ID;
            ImmutableMap.Builder<String, CollisionRule> builder = ImmutableMap.builderWithExpectedSize(values.length);
            for (CollisionRule e : values) {
                builder.put(e.key, e);
            }
            BY_NAME = builder.build();
        }
    }
}

