/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EncryptionResponse
extends DefinedPacket {
    private byte[] sharedSecret;
    private byte[] verifyToken;
    private EncryptionData encryptionData;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.sharedSecret = EncryptionResponse.readArray(buf, 128);
        if (protocolVersion < 759 || protocolVersion >= 761 || buf.readBoolean()) {
            this.verifyToken = EncryptionResponse.readArray(buf, 128);
        } else {
            this.encryptionData = new EncryptionData(buf.readLong(), EncryptionResponse.readArray(buf));
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        EncryptionResponse.writeArray(this.sharedSecret, buf);
        if (this.verifyToken != null) {
            if (protocolVersion >= 759 && protocolVersion <= 761) {
                buf.writeBoolean(true);
            }
            EncryptionResponse.writeArray(this.verifyToken, buf);
        } else {
            if (protocolVersion >= 759 && protocolVersion <= 761) {
                buf.writeBoolean(false);
            }
            buf.writeLong(this.encryptionData.getSalt());
            EncryptionResponse.writeArray(this.encryptionData.getSignature(), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    public EncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    public void setSharedSecret(byte[] sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public void setVerifyToken(byte[] verifyToken) {
        this.verifyToken = verifyToken;
    }

    public void setEncryptionData(EncryptionData encryptionData) {
        this.encryptionData = encryptionData;
    }

    @Override
    public String toString() {
        return "EncryptionResponse(sharedSecret=" + Arrays.toString(this.getSharedSecret()) + ", verifyToken=" + Arrays.toString(this.getVerifyToken()) + ", encryptionData=" + this.getEncryptionData() + ")";
    }

    public EncryptionResponse() {
    }

    public EncryptionResponse(byte[] sharedSecret, byte[] verifyToken, EncryptionData encryptionData) {
        this.sharedSecret = sharedSecret;
        this.verifyToken = verifyToken;
        this.encryptionData = encryptionData;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptionResponse)) {
            return false;
        }
        EncryptionResponse other = (EncryptionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getSharedSecret(), other.getSharedSecret())) {
            return false;
        }
        if (!Arrays.equals(this.getVerifyToken(), other.getVerifyToken())) {
            return false;
        }
        EncryptionData this$encryptionData = this.getEncryptionData();
        EncryptionData other$encryptionData = other.getEncryptionData();
        return !(this$encryptionData == null ? other$encryptionData != null : !((Object)this$encryptionData).equals(other$encryptionData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptionResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSharedSecret());
        result = result * 59 + Arrays.hashCode(this.getVerifyToken());
        EncryptionData $encryptionData = this.getEncryptionData();
        result = result * 59 + ($encryptionData == null ? 43 : ((Object)$encryptionData).hashCode());
        return result;
    }

    public static class EncryptionData {
        private final long salt;
        private final byte[] signature;

        public EncryptionData(long salt, byte[] signature) {
            this.salt = salt;
            this.signature = signature;
        }

        public long getSalt() {
            return this.salt;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncryptionData)) {
                return false;
            }
            EncryptionData other = (EncryptionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSalt() != other.getSalt()) {
                return false;
            }
            return Arrays.equals(this.getSignature(), other.getSignature());
        }

        protected boolean canEqual(Object other) {
            return other instanceof EncryptionData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $salt = this.getSalt();
            result = result * 59 + (int)($salt >>> 32 ^ $salt);
            result = result * 59 + Arrays.hashCode(this.getSignature());
            return result;
        }

        public String toString() {
            return "EncryptionResponse.EncryptionData(salt=" + this.getSalt() + ", signature=" + Arrays.toString(this.getSignature()) + ")";
        }
    }
}

